/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc;

import com.google.common.collect.Lists;
import com.google.gerrit.common.data.ContributorAgreement;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.common.data.SshHostKey;
import com.google.gerrit.common.data.SystemInfoService;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.ssh.SshInfo;
import com.google.gwtjsonrpc.common.AsyncCallback;
import com.google.gwtjsonrpc.common.VoidResult;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.JSch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SystemInfoServiceImpl
implements SystemInfoService {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoServiceImpl.class);
    private static final JSch JSCH = new JSch();
    private final List<HostKey> hostKeys;
    private final Provider<HttpServletRequest> httpRequest;
    private final Provider<GerritConfig> config;
    private final ProjectCache projectCache;

    @Inject
    SystemInfoServiceImpl(SshInfo daemon, Provider<HttpServletRequest> hsr, Provider<GerritConfig> cfg, ProjectCache pc) {
        this.hostKeys = daemon.getHostKeys();
        this.httpRequest = hsr;
        this.config = cfg;
        this.projectCache = pc;
    }

    @Override
    public void contributorAgreements(AsyncCallback<List<ContributorAgreement>> callback) {
        Collection<ContributorAgreement> agreements = this.projectCache.getAllProjects().getConfig().getContributorAgreements();
        ArrayList<ContributorAgreement> cas = Lists.newArrayListWithCapacity(agreements.size());
        for (ContributorAgreement ca : agreements) {
            cas.add(ca.forUi());
        }
        callback.onSuccess(cas);
    }

    @Override
    public void daemonHostKeys(AsyncCallback<List<SshHostKey>> callback) {
        ArrayList<SshHostKey> r = new ArrayList<SshHostKey>(this.hostKeys.size());
        for (HostKey hk : this.hostKeys) {
            String host = hk.getHost();
            if (host.startsWith("*:")) {
                String port = host.substring(2);
                host = "[" + this.httpRequest.get().getServerName() + "]:" + port;
            }
            String fp = hk.getFingerPrint(JSCH);
            r.add(new SshHostKey(host, hk.getType() + " " + hk.getKey(), fp));
        }
        callback.onSuccess(r);
    }

    @Override
    public void clientError(String message, AsyncCallback<VoidResult> callback) {
        HttpServletRequest r = this.httpRequest.get();
        String ua = r.getHeader("User-Agent");
        message = message.replaceAll("\n", "\n  ");
        log.error("Client UI JavaScript error: User-Agent=" + ua + ": " + message);
        callback.onSuccess(VoidResult.INSTANCE);
    }

    @Override
    public void gerritConfig(AsyncCallback<GerritConfig> callback) {
        callback.onSuccess(this.config.get());
    }
}

