/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.args4j;

import com.google.gerrit.common.ProjectUtil;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectControlHandler
extends OptionHandler<ProjectControl> {
    private static final Logger log = LoggerFactory.getLogger(ProjectControlHandler.class);
    private final ProjectControl.GenericFactory projectControlFactory;
    private final Provider<CurrentUser> user;

    @Inject
    public ProjectControlHandler(ProjectControl.GenericFactory projectControlFactory, Provider<CurrentUser> user, @Assisted CmdLineParser parser, @Assisted OptionDef option, @Assisted Setter<ProjectControl> setter) {
        super(parser, option, setter);
        this.projectControlFactory = projectControlFactory;
        this.user = user;
    }

    @Override
    public final int parseArguments(Parameters params) throws CmdLineException {
        ProjectControl control;
        String projectName = params.getParameter(0);
        while (projectName.endsWith("/")) {
            projectName = projectName.substring(0, projectName.length() - 1);
        }
        while (projectName.startsWith("/")) {
            projectName = projectName.substring(1);
        }
        String nameWithoutSuffix = ProjectUtil.stripGitSuffix(projectName);
        Project.NameKey nameKey = new Project.NameKey(nameWithoutSuffix);
        try {
            control = this.projectControlFactory.validateFor(nameKey, 3, this.user.get());
        }
        catch (NoSuchProjectException e) {
            throw new CmdLineException(this.owner, e.getMessage());
        }
        catch (IOException e) {
            log.warn("Cannot load project " + nameWithoutSuffix, e);
            throw new CmdLineException(this.owner, new NoSuchProjectException(nameKey).getMessage());
        }
        this.setter.addValue(control);
        return 1;
    }

    @Override
    public final String getDefaultMetaVariable() {
        return "PROJECT";
    }
}

