/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth.ldap;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.data.ParameterizedString;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.auth.NoSuchUserException;
import com.google.gerrit.server.auth.ldap.LdapQuery;
import com.google.gerrit.server.auth.ldap.LdapRealm;
import com.google.gerrit.server.auth.ldap.LdapType;
import com.google.gerrit.server.auth.ldap.SearchScope;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.util.ssl.BlindSSLSocketFactory;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.eclipse.jgit.lib.Config;

@Singleton
class Helper {
    static final String LDAP_UUID = "ldap:";
    private final Cache<String, ImmutableSet<String>> parentGroups;
    private final Config config;
    private final String server;
    private final String username;
    private final String password;
    private final String referral;
    private final boolean sslVerify;
    private final String authentication;
    private volatile LdapSchema ldapSchema;
    private final String readTimeoutMillis;
    private final String connectTimeoutMillis;
    private final boolean useConnectionPooling;

    @Inject
    Helper(@GerritServerConfig Config config, @Named(value="ldap_groups_byinclude") Cache<String, ImmutableSet<String>> parentGroups) {
        this.config = config;
        this.server = LdapRealm.optional(config, "server");
        this.username = LdapRealm.optional(config, "username");
        this.password = LdapRealm.optional(config, "password", "");
        this.referral = LdapRealm.optional(config, "referral", "ignore");
        this.sslVerify = config.getBoolean("ldap", "sslverify", true);
        this.authentication = LdapRealm.optional(config, "authentication", "simple");
        String readTimeout = LdapRealm.optional(config, "readTimeout");
        this.readTimeoutMillis = readTimeout != null ? Long.toString(ConfigUtil.getTimeUnit(readTimeout, 0L, TimeUnit.MILLISECONDS)) : null;
        String connectTimeout = LdapRealm.optional(config, "connectTimeout");
        this.connectTimeoutMillis = connectTimeout != null ? Long.toString(ConfigUtil.getTimeUnit(connectTimeout, 0L, TimeUnit.MILLISECONDS)) : null;
        this.parentGroups = parentGroups;
        this.useConnectionPooling = LdapRealm.optional(config, "useConnectionPooling", false);
    }

    private Properties createContextProperties() {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.server);
        if (this.server.startsWith("ldaps:") && !this.sslVerify) {
            Class<BlindSSLSocketFactory> factory = BlindSSLSocketFactory.class;
            env.put("java.naming.ldap.factory.socket", factory.getName());
        }
        if (this.readTimeoutMillis != null) {
            env.put("com.sun.jndi.ldap.read.timeout", this.readTimeoutMillis);
        }
        if (this.connectTimeoutMillis != null) {
            env.put("com.sun.jndi.ldap.connect.timeout", this.connectTimeoutMillis);
        }
        if (this.useConnectionPooling) {
            env.put("com.sun.jndi.ldap.connect.pool", "true");
        }
        return env;
    }

    DirContext open() throws NamingException, LoginException {
        Properties env = this.createContextProperties();
        env.put("java.naming.security.authentication", this.authentication);
        env.put("java.naming.referral", this.referral);
        if ("GSSAPI".equals(this.authentication)) {
            return this.kerberosOpen(env);
        }
        if (this.username != null) {
            env.put("java.naming.security.principal", this.username);
            env.put("java.naming.security.credentials", this.password);
        }
        return new InitialDirContext(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirContext kerberosOpen(final Properties env) throws LoginException, NamingException {
        LoginContext ctx = new LoginContext("KerberosLogin");
        ctx.login();
        Subject subject = ctx.getSubject();
        try {
            DirContext dirContext = Subject.doAs(subject, new PrivilegedExceptionAction<DirContext>(){

                @Override
                public DirContext run() throws NamingException {
                    return new InitialDirContext(env);
                }
            });
            return dirContext;
        }
        catch (PrivilegedActionException e) {
            Throwables.propagateIfPossible(e.getException(), NamingException.class);
            Throwables.propagateIfPossible(e.getException(), RuntimeException.class);
            LdapRealm.log.warn("Internal error", e.getException());
            DirContext dirContext = null;
            return dirContext;
        }
        finally {
            ctx.logout();
        }
    }

    DirContext authenticate(String dn, String password) throws AccountException {
        Properties env = this.createContextProperties();
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", dn);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.referral", this.referral);
        try {
            return new InitialDirContext(env);
        }
        catch (NamingException e) {
            throw new AccountException("Incorrect username or password", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LdapSchema getSchema(DirContext ctx) {
        if (this.ldapSchema == null) {
            Helper helper = this;
            synchronized (helper) {
                if (this.ldapSchema == null) {
                    this.ldapSchema = new LdapSchema(ctx);
                }
            }
        }
        return this.ldapSchema;
    }

    LdapQuery.Result findAccount(LdapSchema schema, DirContext ctx, String username, boolean fetchMemberOf) throws NamingException, AccountException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        List<LdapQuery> accountQueryList = fetchMemberOf && schema.type.accountMemberField() != null ? schema.accountWithMemberOfQueryList : schema.accountQueryList;
        for (LdapQuery accountQuery : accountQueryList) {
            List<LdapQuery.Result> res = accountQuery.query(ctx, params);
            if (res.size() == 1) {
                return res.get(0);
            }
            if (res.size() <= 1) continue;
            throw new AccountException("Duplicate users: " + username);
        }
        throw new NoSuchUserException(username);
    }

    Set<AccountGroup.UUID> queryForGroups(DirContext ctx, String username, LdapQuery.Result account) throws NamingException, AccountException {
        LdapSchema schema = this.getSchema(ctx);
        HashSet<String> groupDNs = new HashSet<String>();
        if (!schema.groupMemberQueryList.isEmpty()) {
            HashMap<String, String> params = new HashMap<String, String>();
            if (account == null) {
                try {
                    account = this.findAccount(schema, ctx, username, false);
                }
                catch (AccountException e) {
                    LdapRealm.log.warn("Account " + username + " not found, assuming empty group membership");
                    return Collections.emptySet();
                }
            }
            for (String name : schema.groupMemberQueryList.get(0).getParameters()) {
                params.put(name, account.get(name));
            }
            params.put("username", username);
            for (LdapQuery groupMemberQuery : schema.groupMemberQueryList) {
                for (LdapQuery.Result r : groupMemberQuery.query(ctx, params)) {
                    this.recursivelyExpandGroups(groupDNs, schema, ctx, r.getDN());
                }
            }
        }
        if (schema.accountMemberField != null) {
            Attribute groupAtt;
            if (account == null || account.getAll(schema.accountMemberField) == null) {
                try {
                    account = this.findAccount(schema, ctx, username, true);
                }
                catch (AccountException e) {
                    LdapRealm.log.warn("Account " + username + " not found, assuming empty group membership");
                    return Collections.emptySet();
                }
            }
            if ((groupAtt = account.getAll(schema.accountMemberField)) != null) {
                NamingEnumeration<?> groups = groupAtt.getAll();
                try {
                    while (groups.hasMore()) {
                        String nextDN = (String)groups.next();
                        this.recursivelyExpandGroups(groupDNs, schema, ctx, nextDN);
                    }
                }
                catch (PartialResultException e) {
                    // empty catch block
                }
            }
        }
        HashSet<AccountGroup.UUID> actual = new HashSet<AccountGroup.UUID>();
        for (String dn : groupDNs) {
            actual.add(new AccountGroup.UUID(LDAP_UUID + dn));
        }
        if (actual.isEmpty()) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf(actual);
    }

    private void recursivelyExpandGroups(Set<String> groupDNs, LdapSchema schema, DirContext ctx, String groupDN) {
        if (groupDNs.add(groupDN) && schema.accountMemberField != null) {
            ImmutableCollection cachedParentsDNs = this.parentGroups.getIfPresent(groupDN);
            if (cachedParentsDNs == null) {
                ImmutableSet.Builder dns;
                block8: {
                    dns = ImmutableSet.builder();
                    try {
                        Name compositeGroupName = new CompositeName().add(groupDN);
                        Attribute in = ctx.getAttributes(compositeGroupName, schema.accountMemberFieldArray).get(schema.accountMemberField);
                        if (in == null) break block8;
                        NamingEnumeration<?> groups = in.getAll();
                        try {
                            while (groups.hasMore()) {
                                dns.add((String)groups.next());
                            }
                        }
                        catch (PartialResultException e) {
                        }
                    }
                    catch (NamingException e) {
                        LdapRealm.log.warn("Could not find group " + groupDN, e);
                    }
                }
                cachedParentsDNs = dns.build();
                this.parentGroups.put(groupDN, (ImmutableSet<String>)cachedParentsDNs);
            }
            for (String dn : cachedParentsDNs) {
                this.recursivelyExpandGroups(groupDNs, schema, ctx, dn);
            }
        }
    }

    class LdapSchema {
        final LdapType type;
        final ParameterizedString accountFullName;
        final ParameterizedString accountEmailAddress;
        final ParameterizedString accountSshUserName;
        final String accountMemberField;
        final String[] accountMemberFieldArray;
        final List<LdapQuery> accountQueryList;
        final List<LdapQuery> accountWithMemberOfQueryList;
        final List<String> groupBases;
        final SearchScope groupScope;
        final ParameterizedString groupPattern;
        final ParameterizedString groupName;
        final List<LdapQuery> groupMemberQueryList;

        LdapSchema(DirContext ctx) {
            HashSet<String> accountWithMemberOfAtts;
            this.type = this.discoverLdapType(ctx);
            this.groupMemberQueryList = new ArrayList<LdapQuery>();
            this.accountQueryList = new ArrayList<LdapQuery>();
            this.accountWithMemberOfQueryList = new ArrayList<LdapQuery>();
            HashSet<String> accountAtts = new HashSet<String>();
            this.groupBases = LdapRealm.optionalList(Helper.this.config, "groupBase");
            this.groupScope = LdapRealm.scope(Helper.this.config, "groupScope");
            this.groupPattern = LdapRealm.paramString(Helper.this.config, "groupPattern", this.type.groupPattern());
            this.groupName = LdapRealm.paramString(Helper.this.config, "groupName", this.type.groupName());
            String groupMemberPattern = LdapRealm.optdef(Helper.this.config, "groupMemberPattern", this.type.groupMemberPattern());
            for (String groupBase : this.groupBases) {
                if (groupMemberPattern == null) continue;
                LdapQuery groupMemberQuery = new LdapQuery(groupBase, this.groupScope, new ParameterizedString(groupMemberPattern), Collections.emptySet());
                if (groupMemberQuery.getParameters().isEmpty()) {
                    throw new IllegalArgumentException("No variables in ldap.groupMemberPattern");
                }
                for (String name : groupMemberQuery.getParameters()) {
                    accountAtts.add(name);
                }
                this.groupMemberQueryList.add(groupMemberQuery);
            }
            this.accountFullName = LdapRealm.paramString(Helper.this.config, "accountFullName", this.type.accountFullName());
            if (this.accountFullName != null) {
                accountAtts.addAll(this.accountFullName.getParameterNames());
            }
            this.accountEmailAddress = LdapRealm.paramString(Helper.this.config, "accountEmailAddress", this.type.accountEmailAddress());
            if (this.accountEmailAddress != null) {
                accountAtts.addAll(this.accountEmailAddress.getParameterNames());
            }
            this.accountSshUserName = LdapRealm.paramString(Helper.this.config, "accountSshUserName", this.type.accountSshUserName());
            if (this.accountSshUserName != null) {
                accountAtts.addAll(this.accountSshUserName.getParameterNames());
            }
            this.accountMemberField = LdapRealm.optdef(Helper.this.config, "accountMemberField", this.type.accountMemberField());
            this.accountMemberFieldArray = this.accountMemberField != null ? new String[]{this.accountMemberField} : null;
            SearchScope accountScope = LdapRealm.scope(Helper.this.config, "accountScope");
            String accountPattern = LdapRealm.reqdef(Helper.this.config, "accountPattern", this.type.accountPattern());
            if (this.accountMemberField != null) {
                accountWithMemberOfAtts = new HashSet<String>(accountAtts);
                accountWithMemberOfAtts.add(this.accountMemberField);
            } else {
                accountWithMemberOfAtts = null;
            }
            for (String accountBase : LdapRealm.requiredList(Helper.this.config, "accountBase")) {
                LdapQuery accountQuery = new LdapQuery(accountBase, accountScope, new ParameterizedString(accountPattern), accountAtts);
                if (accountQuery.getParameters().isEmpty()) {
                    throw new IllegalArgumentException("No variables in ldap.accountPattern");
                }
                this.accountQueryList.add(accountQuery);
                if (accountWithMemberOfAtts == null) continue;
                LdapQuery accountWithMemberOfQuery = new LdapQuery(accountBase, accountScope, new ParameterizedString(accountPattern), accountWithMemberOfAtts);
                this.accountWithMemberOfQueryList.add(accountWithMemberOfQuery);
            }
        }

        LdapType discoverLdapType(DirContext ctx) {
            try {
                return LdapType.guessType(ctx);
            }
            catch (NamingException e) {
                LdapRealm.log.warn("Cannot discover type of LDAP server at " + Helper.this.server + ", assuming the server is RFC 2307 compliant.", e);
                return LdapType.RFC_2307;
            }
        }
    }
}

