/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth.ldap;

import com.google.gerrit.reviewdb.client.AuthType;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.auth.AuthBackend;
import com.google.gerrit.server.auth.AuthException;
import com.google.gerrit.server.auth.AuthRequest;
import com.google.gerrit.server.auth.AuthUser;
import com.google.gerrit.server.auth.InvalidCredentialsException;
import com.google.gerrit.server.auth.MissingCredentialsException;
import com.google.gerrit.server.auth.UnknownUserException;
import com.google.gerrit.server.auth.UserNotAllowedException;
import com.google.gerrit.server.auth.ldap.Helper;
import com.google.gerrit.server.auth.ldap.LdapQuery;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import java.util.Locale;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.security.auth.login.LoginException;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthBackend
implements AuthBackend {
    private static final Logger log = LoggerFactory.getLogger(LdapAuthBackend.class);
    private final Helper helper;
    private final AuthConfig authConfig;
    private final boolean lowerCaseUsername;

    @Inject
    public LdapAuthBackend(Helper helper, AuthConfig authConfig, @GerritServerConfig Config config) {
        this.helper = helper;
        this.authConfig = authConfig;
        this.lowerCaseUsername = config.getBoolean("ldap", "localUsernameToLowerCase", false);
    }

    @Override
    public String getDomain() {
        return "ldap";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthUser authenticate(AuthRequest req) throws MissingCredentialsException, InvalidCredentialsException, UnknownUserException, UserNotAllowedException, AuthException {
        AuthUser authUser;
        if (req.getUsername() == null) {
            throw new MissingCredentialsException();
        }
        String username = this.lowerCaseUsername ? req.getUsername().toLowerCase(Locale.US) : req.getUsername();
        DirContext ctx = this.authConfig.getAuthType() == AuthType.LDAP_BIND ? this.helper.authenticate(username, req.getPassword()) : this.helper.open();
        try {
            Helper.LdapSchema schema = this.helper.getSchema(ctx);
            LdapQuery.Result m = this.helper.findAccount(schema, ctx, username, false);
            if (this.authConfig.getAuthType() == AuthType.LDAP) {
                this.helper.authenticate(m.getDN(), req.getPassword()).close();
            }
            authUser = new AuthUser(new AuthUser.UUID(username), username);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    log.warn("Cannot close LDAP query handle", e);
                }
                throw throwable;
            }
            catch (AccountException e) {
                log.error("Cannot query LDAP to authenticate user", e);
                throw new InvalidCredentialsException("Cannot query LDAP for account", e);
            }
            catch (NamingException e) {
                log.error("Cannot query LDAP to authenticate user", e);
                throw new AuthException("Cannot query LDAP for account", e);
            }
            catch (LoginException e) {
                log.error("Cannot authenticate server via JAAS", e);
                throw new AuthException("Cannot query LDAP for account", e);
            }
        }
        try {
            ctx.close();
        }
        catch (NamingException e) {
            log.warn("Cannot close LDAP query handle", e);
        }
        return authUser;
    }
}

