/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.server.index.FieldDef;
import com.google.gwtorm.server.OrmException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema<T> {
    private static final Logger log = LoggerFactory.getLogger(Schema.class);
    private final boolean release;
    private final ImmutableMap<String, FieldDef<T, ?>> fields;
    private int version;

    protected Schema(boolean release, Iterable<FieldDef<T, ?>> fields) {
        this(0, release, fields);
    }

    @VisibleForTesting
    public Schema(int version, boolean release, Iterable<FieldDef<T, ?>> fields) {
        this.version = version;
        this.release = release;
        ImmutableMap.Builder<String, FieldDef<T, ?>> b = ImmutableMap.builder();
        for (FieldDef<T, ?> f : fields) {
            b.put(f.getName(), f);
        }
        this.fields = b.build();
    }

    public final boolean isRelease() {
        return this.release;
    }

    public final int getVersion() {
        return this.version;
    }

    public final ImmutableMap<String, FieldDef<T, ?>> getFields() {
        return this.fields;
    }

    public final boolean hasField(FieldDef<T, ?> field) {
        return this.fields.get(field.getName()) == field;
    }

    public final Iterable<Values<T>> buildFields(final T obj, final FieldDef.FillArgs fillArgs) {
        return FluentIterable.from(this.fields.values()).transform(new Function<FieldDef<T, ?>, Values<T>>(){

            @Override
            public Values<T> apply(FieldDef<T, ?> f) {
                Object v;
                try {
                    v = f.get(obj, fillArgs);
                }
                catch (OrmException e) {
                    log.error(String.format("error getting field %s of %s", f.getName(), obj), e);
                    return null;
                }
                if (v == null) {
                    return null;
                }
                if (f.isRepeatable()) {
                    return new Values(f, (Iterable)v);
                }
                return new Values(f, Collections.singleton(v));
            }
        }).filter(Predicates.notNull());
    }

    public String toString() {
        return Objects.toStringHelper(this).addValue(this.fields.keySet()).toString();
    }

    void setVersion(int version) {
        this.version = version;
    }

    public static class Values<T> {
        private final FieldDef<T, ?> field;
        private final Iterable<?> values;

        private Values(FieldDef<T, ?> field, Iterable<?> values) {
            this.field = field;
            this.values = values;
        }

        public FieldDef<T, ?> getField() {
            return this.field;
        }

        public Iterable<?> getValues() {
            return this.values;
        }
    }
}

