/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.VersionedMetaData;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;

public abstract class AbstractChangeNotes<T>
extends VersionedMetaData {
    private boolean loaded;
    protected final GitRepositoryManager repoManager;
    private final Change change;

    AbstractChangeNotes(GitRepositoryManager repoManager, Change change) {
        this.repoManager = repoManager;
        this.change = new Change(change);
    }

    public Change.Id getChangeId() {
        return this.change.getId();
    }

    public Change getChange() {
        return this.change;
    }

    public T load() throws OrmException {
        if (!this.loaded) {
            Repository repo;
            try {
                repo = this.repoManager.openRepository(this.getProjectName());
            }
            catch (IOException e) {
                throw new OrmException(e);
            }
            try {
                this.load(repo);
                this.loaded = true;
            }
            catch (IOException | ConfigInvalidException e) {
                throw new OrmException(e);
            }
            finally {
                repo.close();
            }
        }
        return this.self();
    }

    protected abstract Project.NameKey getProjectName();

    protected final T self() {
        return (T)this;
    }
}

