/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.patch.DiffExecutor;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListEntry;
import com.google.gerrit.server.patch.PatchListKey;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.Text;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeFormatter;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.ThreeWayMergeStrategy;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchListLoader
extends CacheLoader<PatchListKey, PatchList> {
    static final Logger log = LoggerFactory.getLogger(PatchListLoader.class);
    private final GitRepositoryManager repoManager;
    private final PatchListCache patchListCache;
    private final ThreeWayMergeStrategy mergeStrategy;
    private final ExecutorService diffExecutor;
    private final long timeoutMillis;

    @Inject
    PatchListLoader(GitRepositoryManager mgr, PatchListCache plc, @GerritServerConfig Config cfg, @DiffExecutor ExecutorService de) {
        this.repoManager = mgr;
        this.patchListCache = plc;
        this.mergeStrategy = MergeUtil.getMergeStrategy(cfg);
        this.diffExecutor = de;
        this.timeoutMillis = ConfigUtil.getTimeUnit(cfg, "cache", "diff", "timeout", TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchList load(PatchListKey key) throws IOException, PatchListNotAvailableException {
        try (Repository repo = this.repoManager.openRepository(key.projectKey);){
            PatchList patchList = this.readPatchList(key, repo);
            return patchList;
        }
    }

    private static RawTextComparator comparatorFor(AccountDiffPreference.Whitespace ws) {
        switch (ws) {
            case IGNORE_ALL_SPACE: {
                return RawTextComparator.WS_IGNORE_ALL;
            }
            case IGNORE_SPACE_AT_EOL: {
                return RawTextComparator.WS_IGNORE_TRAILING;
            }
            case IGNORE_SPACE_CHANGE: {
                return RawTextComparator.WS_IGNORE_CHANGE;
            }
        }
        return RawTextComparator.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PatchList readPatchList(PatchListKey key, Repository repo) throws IOException, PatchListNotAvailableException {
        RawTextComparator cmp = PatchListLoader.comparatorFor(key.getWhitespace());
        ObjectReader reader = repo.newObjectReader();
        try {
            RevWalk rw = new RevWalk(reader);
            RevCommit b = rw.parseCommit(key.getNewId());
            RevObject a = this.aFor(key, repo, rw, b);
            if (a == null) {
                PatchListEntry[] entries = new PatchListEntry[]{this.newCommitMessage(cmp, repo, reader, null, b)};
                PatchList patchList = new PatchList(a, b, true, entries);
                return patchList;
            }
            boolean againstParent = b.getParentCount() > 0 && b.getParent(0) == a;
            RevCommit aCommit = a instanceof RevCommit ? (RevCommit)a : null;
            RevTree aTree = rw.parseTree(a);
            RevTree bTree = b.getTree();
            DiffFormatter df = new DiffFormatter(DisabledOutputStream.INSTANCE);
            df.setRepository(repo);
            df.setDiffComparator(cmp);
            df.setDetectRenames(true);
            List<DiffEntry> diffEntries = df.scan(aTree, bTree);
            ImmutableSet<String> paths = key.getOldId() != null ? FluentIterable.from(this.patchListCache.get(new PatchListKey(key.projectKey, null, key.getNewId(), key.getWhitespace())).getPatches()).transform(new Function<PatchListEntry, String>(){

                @Override
                public String apply(PatchListEntry entry) {
                    return entry.getNewName();
                }
            }).toSet() : null;
            int cnt = diffEntries.size();
            ArrayList<PatchListEntry> entries = new ArrayList<PatchListEntry>();
            entries.add(this.newCommitMessage(cmp, repo, reader, againstParent ? null : aCommit, b));
            for (int i = 0; i < cnt; ++i) {
                DiffEntry diffEntry = diffEntries.get(i);
                if (paths != null && !paths.contains(diffEntry.getNewPath()) && !paths.contains(diffEntry.getOldPath())) continue;
                FileHeader fh = this.toFileHeader(key, df, diffEntry);
                entries.add(this.newEntry(aTree, fh));
            }
            PatchList patchList = new PatchList(a, b, againstParent, entries.toArray(new PatchListEntry[entries.size()]));
            return patchList;
        }
        finally {
            reader.release();
        }
    }

    private FileHeader toFileHeader(PatchListKey key, final DiffFormatter diffFormatter, final DiffEntry diffEntry) throws IOException {
        Future<FileHeader> result = this.diffExecutor.submit(new Callable<FileHeader>(){

            @Override
            public FileHeader call() throws IOException {
                return diffFormatter.toFileHeader(diffEntry);
            }
        });
        try {
            return result.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            log.warn(this.timeoutMillis + " ms timeout reached for Diff loader" + " in project " + key.projectKey.get() + " on commit " + key.getNewId().name() + " on path " + diffEntry.getNewPath() + " comparing " + diffEntry.getOldId().name() + ".." + diffEntry.getNewId().name());
            result.cancel(true);
            return this.toFileHeaderWithoutMyersDiff(diffFormatter, diffEntry);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf(e.getCause(), IOException.class);
            throw new IOException(e.getMessage(), e.getCause());
        }
    }

    private FileHeader toFileHeaderWithoutMyersDiff(DiffFormatter diffFormatter, DiffEntry diffEntry) throws IOException {
        HistogramDiff histogramDiff = new HistogramDiff();
        histogramDiff.setFallbackAlgorithm(null);
        diffFormatter.setDiffAlgorithm(histogramDiff);
        return diffFormatter.toFileHeader(diffEntry);
    }

    private PatchListEntry newCommitMessage(RawTextComparator cmp, Repository db, ObjectReader reader, RevCommit aCommit, RevCommit bCommit) throws IOException {
        StringBuilder hdr = new StringBuilder();
        hdr.append("diff --git");
        if (aCommit != null) {
            hdr.append(" a/").append("/COMMIT_MSG");
        } else {
            hdr.append(" ").append("/dev/null");
        }
        hdr.append(" b/").append("/COMMIT_MSG");
        hdr.append("\n");
        if (aCommit != null) {
            hdr.append("--- a/").append("/COMMIT_MSG").append("\n");
        } else {
            hdr.append("--- ").append("/dev/null").append("\n");
        }
        hdr.append("+++ b/").append("/COMMIT_MSG").append("\n");
        Text aText = aCommit != null ? Text.forCommit(db, reader, aCommit) : Text.EMPTY;
        Text bText = Text.forCommit(db, reader, bCommit);
        byte[] rawHdr = hdr.toString().getBytes("UTF-8");
        RawText aRawText = new RawText(aText.getContent());
        RawText bRawText = new RawText(bText.getContent());
        EditList edits = new HistogramDiff().diff(cmp, aRawText, bRawText);
        FileHeader fh = new FileHeader(rawHdr, edits, FileHeader.PatchType.UNIFIED);
        return new PatchListEntry(fh, edits);
    }

    private PatchListEntry newEntry(RevTree aTree, FileHeader fileHeader) {
        FileMode oldMode = fileHeader.getOldMode();
        FileMode newMode = fileHeader.getNewMode();
        if (oldMode == FileMode.GITLINK || newMode == FileMode.GITLINK) {
            return new PatchListEntry(fileHeader, Collections.emptyList());
        }
        if (aTree == null || fileHeader.getPatchType() != FileHeader.PatchType.UNIFIED || fileHeader.getHunks().isEmpty()) {
            return new PatchListEntry(fileHeader, Collections.emptyList());
        }
        EditList edits = fileHeader.toEditList();
        if (edits.isEmpty()) {
            return new PatchListEntry(fileHeader, Collections.emptyList());
        }
        return new PatchListEntry(fileHeader, edits);
    }

    private RevObject aFor(PatchListKey key, Repository repo, RevWalk rw, RevCommit b) throws IOException {
        if (key.getOldId() != null) {
            return rw.parseAny(key.getOldId());
        }
        switch (b.getParentCount()) {
            case 0: {
                return rw.parseAny(PatchListLoader.emptyTree(repo));
            }
            case 1: {
                RevCommit r = b.getParent(0);
                rw.parseBody(r);
                return r;
            }
            case 2: {
                return PatchListLoader.automerge(repo, rw, b, this.mergeStrategy);
            }
        }
        return null;
    }

    public static RevTree automerge(Repository repo, RevWalk rw, RevCommit b, ThreeWayMergeStrategy mergeStrategy) throws IOException {
        return PatchListLoader.automerge(repo, rw, b, mergeStrategy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RevTree automerge(Repository repo, RevWalk rw, RevCommit b, ThreeWayMergeStrategy mergeStrategy, boolean save) throws IOException {
        String hash = b.name();
        String refName = "refs/cache-automerge/" + hash.substring(0, 2) + "/" + hash.substring(2);
        Ref ref = repo.getRef(refName);
        if (ref != null && ref.getObjectId() != null) {
            return rw.parseTree(ref.getObjectId());
        }
        ResolveMerger m = (ResolveMerger)mergeStrategy.newMerger(repo, true);
        final ObjectInserter ins = repo.newObjectInserter();
        try {
            ObjectId treeId;
            boolean couldMerge;
            DirCache dc = DirCache.newInCore();
            m.setDirCache(dc);
            m.setObjectInserter(new ObjectInserter.Filter(){

                @Override
                protected ObjectInserter delegate() {
                    return ins;
                }

                @Override
                public void flush() {
                }

                @Override
                public void release() {
                }
            });
            try {
                couldMerge = m.merge(b.getParents());
            }
            catch (IOException e) {
                log.warn("Error attempting automerge " + refName, e);
                RevTree revTree = null;
                ins.release();
                return revTree;
            }
            if (couldMerge) {
                treeId = m.getResultTreeId();
            } else {
                RevCommit ours = b.getParent(0);
                RevCommit theirs = b.getParent(1);
                rw.parseBody(ours);
                rw.parseBody(theirs);
                String oursMsg = ours.getShortMessage();
                String theirsMsg = theirs.getShortMessage();
                String oursName = String.format("HEAD   (%s %s)", ours.abbreviate(6).name(), oursMsg.substring(0, Math.min(oursMsg.length(), 60)));
                String theirsName = String.format("BRANCH (%s %s)", theirs.abbreviate(6).name(), theirsMsg.substring(0, Math.min(theirsMsg.length(), 60)));
                MergeFormatter fmt = new MergeFormatter();
                Map<String, MergeResult<? extends Sequence>> r = m.getMergeResults();
                HashMap<String, ObjectId> resolved = new HashMap<String, ObjectId>();
                for (Map.Entry<String, MergeResult<? extends Sequence>> entry : r.entrySet()) {
                    MergeResult<? extends Sequence> p = entry.getValue();
                    TemporaryBuffer.LocalFile buf = new TemporaryBuffer.LocalFile(0xA00000);
                    try {
                        fmt.formatMerge(buf, p, "BASE", oursName, theirsName, "UTF-8");
                        buf.close();
                        try (InputStream in = ((TemporaryBuffer)buf).openInputStream();){
                            resolved.put(entry.getKey(), ins.insert(3, ((TemporaryBuffer)buf).length(), in));
                        }
                    }
                    finally {
                        ((TemporaryBuffer)buf).destroy();
                    }
                }
                DirCacheBuilder builder = dc.builder();
                int cnt = dc.getEntryCount();
                int i = 0;
                while (i < cnt) {
                    DirCacheEntry entry = dc.getEntry(i);
                    if (entry.getStage() == 0) {
                        builder.add(entry);
                        ++i;
                        continue;
                    }
                    int next = dc.nextEntry(i);
                    String path = entry.getPathString();
                    DirCacheEntry res = new DirCacheEntry(path);
                    if (resolved.containsKey(path)) {
                        res.setFileMode(entry.getFileMode());
                        res.setObjectId((AnyObjectId)resolved.get(path));
                    } else if (next == i + 1) {
                        res.setFileMode(entry.getFileMode());
                        res.setObjectId(entry.getObjectId());
                    } else if (next == i + 2) {
                        entry = dc.getEntry(i + 1);
                        res.setFileMode(entry.getFileMode());
                        res.setObjectId(entry.getObjectId());
                    } else {
                        res.setFileMode(entry.getFileMode());
                        res.setObjectId(entry.getObjectId());
                    }
                    builder.add(res);
                    i = next;
                }
                builder.finish();
                treeId = dc.writeTree(ins);
            }
            ins.flush();
            if (save) {
                RefUpdate update = repo.updateRef(refName);
                update.setNewObjectId(treeId);
                update.disableRefLog();
                update.forceUpdate();
            }
            RevTree revTree = rw.lookupTree(treeId);
            return revTree;
        }
        finally {
            ins.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectId emptyTree(Repository repo) throws IOException {
        ObjectInserter oi = repo.newObjectInserter();
        try {
            ObjectId id = oi.insert(2, new byte[0]);
            oi.flush();
            ObjectId objectId = id;
            return objectId;
        }
        finally {
            oi.release();
        }
    }
}

