/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.annotations.PluginCanonicalWebUrl;
import com.google.gerrit.extensions.annotations.PluginData;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.gerrit.extensions.registration.ReloadableRegistrationHandle;
import com.google.gerrit.lifecycle.LifecycleManager;
import com.google.gerrit.server.PluginUser;
import com.google.gerrit.server.plugins.AutoRegisterModules;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.PluginContentScanner;
import com.google.gerrit.server.plugins.PluginGuiceEnvironment;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.gerrit.server.util.RequestContext;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;

public class ServerPlugin
extends Plugin {
    private final Manifest manifest;
    private final PluginContentScanner scanner;
    private final File dataDir;
    private final String pluginCanonicalWebUrl;
    private final ClassLoader classLoader;
    private Class<? extends Module> sysModule;
    private Class<? extends Module> sshModule;
    private Class<? extends Module> httpModule;
    private Injector sysInjector;
    private Injector sshInjector;
    private Injector httpInjector;
    private LifecycleManager manager;
    private List<ReloadableRegistrationHandle<?>> reloadableHandles;

    public ServerPlugin(String name, String pluginCanonicalWebUrl, PluginUser pluginUser, File srcJar, FileSnapshot snapshot, PluginContentScanner scanner, File dataDir, ClassLoader classLoader) throws InvalidPluginException {
        super(name, srcJar, pluginUser, snapshot, Plugin.getApiType(ServerPlugin.getPluginManifest(scanner)));
        this.pluginCanonicalWebUrl = pluginCanonicalWebUrl;
        this.scanner = scanner;
        this.dataDir = dataDir;
        this.classLoader = classLoader;
        this.manifest = ServerPlugin.getPluginManifest(scanner);
        this.loadGuiceModules(this.manifest, classLoader);
    }

    private void loadGuiceModules(Manifest manifest, ClassLoader classLoader) throws InvalidPluginException {
        Attributes main = manifest.getMainAttributes();
        String sysName = main.getValue("Gerrit-Module");
        String sshName = main.getValue("Gerrit-SshModule");
        String httpName = main.getValue("Gerrit-HttpModule");
        if (!Strings.isNullOrEmpty(sshName) && this.getApiType() != Plugin.ApiType.PLUGIN) {
            throw new InvalidPluginException(String.format("Using Gerrit-SshModule requires Gerrit-ApiType: %s", new Object[]{Plugin.ApiType.PLUGIN}));
        }
        try {
            this.sysModule = ServerPlugin.load(sysName, classLoader);
            this.sshModule = ServerPlugin.load(sshName, classLoader);
            this.httpModule = ServerPlugin.load(httpName, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidPluginException("Unable to load plugin Guice Modules", e);
        }
    }

    private static Class<? extends Module> load(String name, ClassLoader pluginLoader) throws ClassNotFoundException {
        if (Strings.isNullOrEmpty(name)) {
            return null;
        }
        Class<?> clazz = Class.forName(name, false, pluginLoader);
        if (!Module.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(String.format("Class %s does not implement %s", name, Module.class.getName()));
        }
        return clazz;
    }

    File getSrcJar() {
        return this.getSrcFile();
    }

    private static Manifest getPluginManifest(PluginContentScanner scanner) throws InvalidPluginException {
        try {
            return scanner.getManifest();
        }
        catch (IOException e) {
            throw new InvalidPluginException("Cannot get plugin manifest", e);
        }
    }

    @Override
    @Nullable
    public String getVersion() {
        Attributes main = this.manifest.getMainAttributes();
        return main.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    @Override
    boolean canReload() {
        Attributes main = this.manifest.getMainAttributes();
        String v = main.getValue("Gerrit-ReloadMode");
        if (Strings.isNullOrEmpty(v) || "reload".equalsIgnoreCase(v)) {
            return true;
        }
        if ("restart".equalsIgnoreCase(v)) {
            return false;
        }
        PluginLoader.log.warn(String.format("Plugin %s has invalid Gerrit-ReloadMode %s; assuming restart", this.getName(), v));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void start(PluginGuiceEnvironment env) throws Exception {
        RequestContext oldContext = env.enter(this);
        try {
            this.startPlugin(env);
        }
        finally {
            env.exit(oldContext);
        }
    }

    private void startPlugin(PluginGuiceEnvironment env) throws Exception {
        LinkedList<Module> modules;
        Injector root = this.newRootInjector(env);
        this.manager = new LifecycleManager();
        AutoRegisterModules auto = null;
        if (this.sysModule == null && this.sshModule == null && this.httpModule == null) {
            auto = new AutoRegisterModules(this.getName(), env, this.scanner, this.classLoader);
            auto.discover();
        }
        if (this.sysModule != null) {
            this.sysInjector = root.createChildInjector(root.getInstance(this.sysModule));
            this.manager.add(this.sysInjector);
        } else if (auto != null && auto.sysModule != null) {
            this.sysInjector = root.createChildInjector(auto.sysModule);
            this.manager.add(this.sysInjector);
        } else {
            this.sysInjector = root;
        }
        if (env.hasSshModule()) {
            modules = Lists.newLinkedList();
            if (this.getApiType() == Plugin.ApiType.PLUGIN) {
                modules.add(env.getSshModule());
            }
            if (this.sshModule != null) {
                modules.add(this.sysInjector.getInstance(this.sshModule));
                this.sshInjector = this.sysInjector.createChildInjector(modules);
                this.manager.add(this.sshInjector);
            } else if (auto != null && auto.sshModule != null) {
                modules.add(auto.sshModule);
                this.sshInjector = this.sysInjector.createChildInjector(modules);
                this.manager.add(this.sshInjector);
            }
        }
        if (env.hasHttpModule()) {
            modules = Lists.newLinkedList();
            if (this.getApiType() == Plugin.ApiType.PLUGIN) {
                modules.add(env.getHttpModule());
            }
            if (this.httpModule != null) {
                modules.add(this.sysInjector.getInstance(this.httpModule));
                this.httpInjector = this.sysInjector.createChildInjector(modules);
                this.manager.add(this.httpInjector);
            } else if (auto != null && auto.httpModule != null) {
                modules.add(auto.httpModule);
                this.httpInjector = this.sysInjector.createChildInjector(modules);
                this.manager.add(this.httpInjector);
            }
        }
        this.manager.start();
    }

    private Injector newRootInjector(PluginGuiceEnvironment env) {
        ArrayList<Module> modules = Lists.newArrayListWithCapacity(4);
        if (this.getApiType() == Plugin.ApiType.PLUGIN) {
            modules.add(env.getSysModule());
        }
        modules.add(new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(PluginUser.class).toInstance(ServerPlugin.this.getPluginUser());
                this.bind(String.class).annotatedWith(PluginName.class).toInstance(ServerPlugin.this.getName());
                this.bind(String.class).annotatedWith(PluginCanonicalWebUrl.class).toInstance(ServerPlugin.this.pluginCanonicalWebUrl);
                this.bind(File.class).annotatedWith(PluginData.class).toProvider(new Provider<File>(){
                    private volatile boolean ready;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public File get() {
                        if (!this.ready) {
                            File file = ServerPlugin.this.dataDir;
                            synchronized (file) {
                                if (!ServerPlugin.this.dataDir.exists() && !ServerPlugin.this.dataDir.mkdirs()) {
                                    throw new ProvisionException(String.format("Cannot create %s for plugin %s", ServerPlugin.this.dataDir.getAbsolutePath(), ServerPlugin.this.getName()));
                                }
                                this.ready = true;
                            }
                        }
                        return ServerPlugin.this.dataDir;
                    }
                });
            }
        });
        return Guice.createInjector(modules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void stop(PluginGuiceEnvironment env) {
        if (this.manager != null) {
            RequestContext oldContext = env.enter(this);
            try {
                this.manager.stop();
            }
            finally {
                env.exit(oldContext);
            }
            this.manager = null;
            this.sysInjector = null;
            this.sshInjector = null;
            this.httpInjector = null;
        }
    }

    @Override
    public Injector getSysInjector() {
        return this.sysInjector;
    }

    @Override
    @Nullable
    public Injector getSshInjector() {
        return this.sshInjector;
    }

    @Override
    @Nullable
    public Injector getHttpInjector() {
        return this.httpInjector;
    }

    @Override
    public void add(RegistrationHandle handle) {
        if (this.manager != null) {
            if (handle instanceof ReloadableRegistrationHandle) {
                if (this.reloadableHandles == null) {
                    this.reloadableHandles = Lists.newArrayList();
                }
                this.reloadableHandles.add((ReloadableRegistrationHandle)handle);
            }
            this.manager.add(handle);
        }
    }

    @Override
    public PluginContentScanner getContentScanner() {
        return this.scanner;
    }

    public static final class CacheKey {
        private final String name;

        CacheKey(String name) {
            this.name = name;
        }

        public String toString() {
            int id = System.identityHashCode(this);
            return String.format("Plugin[%s@%x]", this.name, id);
        }
    }
}

