/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.server.project.DashboardResource;
import com.google.gerrit.server.project.DashboardsCollection;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.kohsuke.args4j.Option;

class GetDashboard
implements RestReadView<DashboardResource> {
    private final DashboardsCollection dashboards;
    @Option(name="--inherited", usage="include inherited dashboards")
    private boolean inherited;

    @Inject
    GetDashboard(DashboardsCollection dashboards) {
        this.dashboards = dashboards;
    }

    public DashboardsCollection.DashboardInfo apply(DashboardResource resource) throws ResourceNotFoundException, ResourceConflictException, IOException {
        if (this.inherited && !resource.isProjectDefault()) {
            throw new ResourceNotFoundException("inherited");
        }
        String project = resource.getControl().getProject().getName();
        if (resource.isProjectDefault()) {
            try {
                resource = this.defaultOf(resource.getControl());
            }
            catch (ConfigInvalidException e) {
                throw new ResourceConflictException(e.getMessage());
            }
        }
        return DashboardsCollection.parse(resource.getControl().getProject(), resource.getRefName().substring("refs/meta/dashboards/".length()), resource.getPathName(), resource.getConfig(), project, true);
    }

    private DashboardResource defaultOf(ProjectControl ctl) throws ResourceNotFoundException, IOException, ConfigInvalidException {
        String id = ctl.getProject().getLocalDefaultDashboard();
        if (Strings.isNullOrEmpty(id)) {
            id = ctl.getProject().getDefaultDashboard();
        }
        if ("default".equals(id)) {
            throw new ResourceNotFoundException();
        }
        if (!Strings.isNullOrEmpty(id)) {
            return this.parse(ctl, id);
        }
        if (!this.inherited) {
            throw new ResourceNotFoundException();
        }
        for (ProjectState ps : ctl.getProjectState().tree()) {
            id = ps.getProject().getDefaultDashboard();
            if ("default".equals(id)) {
                throw new ResourceNotFoundException();
            }
            if (Strings.isNullOrEmpty(id)) continue;
            ctl = ps.controlFor(ctl.getCurrentUser());
            return this.parse(ctl, id);
        }
        throw new ResourceNotFoundException();
    }

    private DashboardResource parse(ProjectControl ctl, String id) throws ResourceNotFoundException, IOException, ConfigInvalidException {
        ArrayList<String> p = Lists.newArrayList(Splitter.on(':').limit(2).split(id));
        String ref = Url.encode((String)p.get(0));
        String path = Url.encode((String)p.get(1));
        return this.dashboards.parse(new ProjectResource(ctl), IdString.fromUrl(ref + ':' + path));
    }
}

