/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.query.change.ChangeCosts;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeDataResultSet;
import com.google.gerrit.server.query.change.ChangeDataSource;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.ObjectId;

class CommitPredicate
extends IndexPredicate<ChangeData>
implements ChangeDataSource {
    private final ChangeQueryBuilder.Arguments args;
    private final AbbreviatedObjectId abbrevId;

    CommitPredicate(ChangeQueryBuilder.Arguments args, AbbreviatedObjectId id) {
        super(ChangeField.COMMIT, id.name());
        this.args = args;
        this.abbrevId = id;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        for (PatchSet p : object.patches()) {
            ObjectId id;
            if (p.getRevision() == null || p.getRevision().get() == null || this.abbrevId.prefixCompare(id = ObjectId.fromString(p.getRevision().get())) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResultSet<ChangeData> read() throws OrmException {
        RevId id = new RevId(this.abbrevId.name());
        if (id.isComplete()) {
            return ChangeDataResultSet.patchSet(this.args.changeDataFactory, this.args.db, this.args.db.get().patchSets().byRevision(id));
        }
        return ChangeDataResultSet.patchSet(this.args.changeDataFactory, this.args.db, this.args.db.get().patchSets().byRevisionRange(id, id.max()));
    }

    @Override
    public boolean hasChange() {
        return false;
    }

    @Override
    public int getCardinality() {
        return 5;
    }

    @Override
    public int getCost() {
        return ChangeCosts.cost(30, this.getCardinality());
    }
}

