/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.securestore;

import com.google.gerrit.common.FileUtil;
import com.google.gerrit.extensions.annotations.Export;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.securestore.SecureStore;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;

@Singleton
@Export(value="default")
public class DefaultSecureStore
implements SecureStore {
    public static final String NAME = "default";
    private final FileBasedConfig sec;

    @Inject
    DefaultSecureStore(SitePaths site) {
        File secureConfig = new File(site.etc_dir, "secure.config");
        this.sec = new FileBasedConfig(secureConfig, FS.DETECTED);
        try {
            this.sec.load();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load secure.config", e);
        }
    }

    @Override
    public String get(String section, String subsection, String name) {
        return this.sec.getString(section, subsection, name);
    }

    @Override
    public void set(String section, String subsection, String name, String value) {
        if (value != null) {
            this.sec.setString(section, subsection, name, value);
        } else {
            this.sec.unset(section, subsection, name);
        }
        this.save();
    }

    @Override
    public void unset(String section, String subsection, String name) {
        this.sec.unset(section, subsection, name);
        this.save();
    }

    private void save() {
        try {
            DefaultSecureStore.saveSecure(this.sec);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot save secure.config", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveSecure(FileBasedConfig sec) throws IOException {
        if (FileUtil.modified(sec)) {
            byte[] out = Constants.encode(sec.toText());
            File path = sec.getFile();
            LockFile lf = new LockFile(path, FS.DETECTED);
            if (!lf.lock()) {
                throw new IOException("Cannot lock " + path);
            }
            try {
                FileUtil.chmod(384, new File(path.getParentFile(), path.getName() + ".lock"));
                lf.write(out);
                if (!lf.commit()) {
                    throw new IOException("Cannot commit write to " + path);
                }
            }
            finally {
                lf.unlock();
            }
        }
    }
}

