/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.reviewdb.client.PatchSetApproval;

public class LabelVote {
    private final String name;
    private final short value;

    public static LabelVote parse(String text) {
        int i;
        Preconditions.checkArgument(!Strings.isNullOrEmpty(text), "Empty label vote");
        if (text.charAt(0) == '-') {
            return new LabelVote(text.substring(1), 0);
        }
        int sign = 0;
        for (i = text.length() - 1; i >= 0; --i) {
            char c = text.charAt(i);
            if (c == '-') {
                sign = -1;
                break;
            }
            if (c == '+') {
                sign = 1;
                break;
            }
            if ('0' > c || c > '9') break;
        }
        if (sign == 0) {
            return new LabelVote(text, 1);
        }
        return new LabelVote(text.substring(0, i), (short)(sign * Short.parseShort(text.substring(i + 1))));
    }

    public static LabelVote parseWithEquals(String text) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(text), "Empty label vote");
        int e = text.lastIndexOf(61);
        Preconditions.checkArgument(e >= 0, "Label vote missing '=': %s", text);
        return new LabelVote(text.substring(0, e), Short.parseShort(text.substring(e + 1), text.length()));
    }

    public LabelVote(String name, short value) {
        this.name = LabelType.checkNameInternal(name);
        this.value = value;
    }

    public LabelVote(PatchSetApproval psa) {
        this(psa.getLabel(), psa.getValue());
    }

    public String getLabel() {
        return this.name;
    }

    public short getValue() {
        return this.value;
    }

    public String format() {
        if (this.value == 0) {
            return '-' + this.name;
        }
        if (this.value < 0) {
            return this.name + this.value;
        }
        return this.name + '+' + this.value;
    }

    public String formatWithEquals() {
        if (this.value <= 0) {
            return this.name + '=' + this.value;
        }
        return this.name + "=+" + this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof LabelVote) {
            LabelVote l = (LabelVote)o;
            return Objects.equal(this.name, l.name) && this.value == l.value;
        }
        return false;
    }

    public String toString() {
        return this.format();
    }
}

