/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore.internal;

import org.eclipse.jgit.ignore.internal.NameMatcher;

public class TrailingAsteriskMatcher
extends NameMatcher {
    TrailingAsteriskMatcher(String pattern, Character pathSeparator, boolean dirOnly) {
        super(pattern, pathSeparator, dirOnly);
        if (this.subPattern.charAt(this.subPattern.length() - 1) != '*') {
            String string = String.valueOf(pattern);
            throw new IllegalArgumentException(string.length() != 0 ? "Pattern must have trailing asterisk: ".concat(string) : new String("Pattern must have trailing asterisk: "));
        }
    }

    @Override
    public boolean matches(String segment, int startIncl, int endExcl, boolean assumeDirectory) {
        String s = this.subPattern;
        int subLenth = s.length() - 1;
        if (subLenth == 0) {
            return true;
        }
        if (subLenth > endExcl - startIncl) {
            return false;
        }
        for (int i = 0; i < subLenth; ++i) {
            char c2;
            char c1 = s.charAt(i);
            if (c1 == (c2 = segment.charAt(i + startIncl))) continue;
            return false;
        }
        return true;
    }
}

