/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.RenameCallback;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class FollowFilter
extends TreeFilter {
    private final PathFilter path;
    final DiffConfig cfg;
    private RenameCallback renameCallback;

    public static FollowFilter create(String path, DiffConfig cfg) {
        return new FollowFilter(PathFilter.create(path), cfg);
    }

    FollowFilter(PathFilter path, DiffConfig cfg) {
        this.path = path;
        this.cfg = cfg;
    }

    public String getPath() {
        return this.path.getPath();
    }

    @Override
    public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.path.include(walker) && ANY_DIFF.include(walker);
    }

    @Override
    public boolean shouldBeRecursive() {
        return this.path.shouldBeRecursive() || ANY_DIFF.shouldBeRecursive();
    }

    @Override
    public TreeFilter clone() {
        return new FollowFilter(this.path.clone(), this.cfg);
    }

    @Override
    public String toString() {
        String string = String.valueOf(String.valueOf(this.path.toString()));
        String string2 = String.valueOf(String.valueOf(ANY_DIFF.toString()));
        return new StringBuilder(15 + string.length() + string2.length()).append("(FOLLOW(").append(string).append(")").append(" AND ").append(string2).append(")").toString();
    }

    public RenameCallback getRenameCallback() {
        return this.renameCallback;
    }

    public void setRenameCallback(RenameCallback callback) {
        this.renameCallback = callback;
    }
}

