/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

public class FS_Win32
extends FS {
    public FS_Win32() {
    }

    protected FS_Win32(FS src) {
        super(src);
    }

    @Override
    public FS newInstance() {
        return new FS_Win32(this);
    }

    @Override
    public boolean supportsExecute() {
        return false;
    }

    @Override
    public boolean canExecute(File f) {
        return false;
    }

    @Override
    public boolean setExecute(File f, boolean canExec) {
        return false;
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public boolean retryFailedLockFileCommit() {
        return true;
    }

    @Override
    protected File discoverGitPrefix() {
        String path = SystemReader.getInstance().getenv("PATH");
        File gitExe = FS_Win32.searchPath(path, "git.exe", "git.cmd");
        if (gitExe != null) {
            return FS_Win32.resolveGrandparentFile(gitExe);
        }
        String w = FS_Win32.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name());
        if (w != null && (gitExe = this.resolve(null, w)) != null) {
            return FS_Win32.resolveGrandparentFile(gitExe);
        }
        return null;
    }

    private static File resolveGrandparentFile(File grandchild) {
        File parent;
        if (grandchild != null && (parent = grandchild.getParentFile()) != null) {
            return parent.getParentFile();
        }
        return null;
    }

    @Override
    protected File userHomeImpl() {
        String homePath;
        String home = SystemReader.getInstance().getenv("HOME");
        if (home != null) {
            return this.resolve(null, home);
        }
        String homeDrive = SystemReader.getInstance().getenv("HOMEDRIVE");
        if (homeDrive != null && (homePath = SystemReader.getInstance().getenv("HOMEPATH")) != null) {
            return new File(homeDrive, homePath);
        }
        String homeShare = SystemReader.getInstance().getenv("HOMESHARE");
        if (homeShare != null) {
            return new File(homeShare);
        }
        return super.userHomeImpl();
    }

    @Override
    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(3 + args.length);
        argv.add("cmd.exe");
        argv.add("/c");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }
}

