/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.ChangeKind;
import com.google.gerrit.server.change.ChangeKindCache;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.LabelNormalizer;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class ApprovalCopier {
    private final GitRepositoryManager repoManager;
    private final ProjectCache projectCache;
    private final ChangeKindCache changeKindCache;
    private final LabelNormalizer labelNormalizer;
    private final ChangeData.Factory changeDataFactory;

    @Inject
    ApprovalCopier(GitRepositoryManager repoManager, ProjectCache projectCache, ChangeKindCache changeKindCache, LabelNormalizer labelNormalizer, ChangeData.Factory changeDataFactory) {
        this.repoManager = repoManager;
        this.projectCache = projectCache;
        this.changeKindCache = changeKindCache;
        this.labelNormalizer = labelNormalizer;
        this.changeDataFactory = changeDataFactory;
    }

    public void copy(ReviewDb db, ChangeControl ctl, PatchSet ps) throws OrmException {
        db.patchSetApprovals().insert(this.getForPatchSet(db, ctl, ps));
    }

    Iterable<PatchSetApproval> getForPatchSet(ReviewDb db, ChangeControl ctl, PatchSet.Id psId) throws OrmException {
        return this.getForPatchSet(db, ctl, db.patchSets().get(psId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<PatchSetApproval> getForPatchSet(ReviewDb db, ChangeControl ctl, PatchSet ps) throws OrmException {
        ChangeData cd = this.changeDataFactory.create(db, ctl);
        ProjectState project = this.projectCache.checkedGet(cd.change().getDest().getParentKey());
        ListMultimap<PatchSet.Id, PatchSetApproval> all = cd.approvals();
        HashBasedTable<String, Account.Id, PatchSetApproval> byUser = HashBasedTable.create();
        for (PatchSetApproval psa : all.get(ps.getId())) {
            byUser.put(psa.getLabel(), psa.getAccountId(), psa);
        }
        TreeMap<Integer, PatchSet> patchSets = ApprovalCopier.getPatchSets(cd);
        NavigableSet<Integer> allPsIds = patchSets.navigableKeySet();
        Repository repo = this.repoManager.openRepository(project.getProject().getNameKey());
        try {
            Collection allPrior = patchSets.descendingMap().tailMap(ps.getId().get(), false).values();
            for (PatchSet priorPs : allPrior) {
                List<PatchSetApproval> priorApprovals = all.get(priorPs.getId());
                if (priorApprovals.isEmpty()) continue;
                ChangeKind kind = this.changeKindCache.getChangeKind(project, repo, ObjectId.fromString(priorPs.getRevision().get()), ObjectId.fromString(ps.getRevision().get()));
                for (PatchSetApproval psa : priorApprovals) {
                    if (byUser.contains(psa.getLabel(), psa.getAccountId()) || !ApprovalCopier.canCopy(project, psa, ps.getId(), allPsIds, kind)) continue;
                    byUser.put(psa.getLabel(), psa.getAccountId(), ApprovalCopier.copy(psa, ps.getId()));
                }
            }
            Iterable<PatchSetApproval> iterable = this.labelNormalizer.normalize(ctl, byUser.values()).getNormalized();
            repo.close();
            return iterable;
        }
        catch (Throwable throwable) {
            try {
                repo.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new OrmException(e);
            }
        }
    }

    private static TreeMap<Integer, PatchSet> getPatchSets(ChangeData cd) throws OrmException {
        Collection<PatchSet> patchSets = cd.patches();
        TreeMap<Integer, PatchSet> result = Maps.newTreeMap();
        for (PatchSet ps : patchSets) {
            result.put(ps.getId().get(), ps);
        }
        return result;
    }

    private static boolean canCopy(ProjectState project, PatchSetApproval psa, PatchSet.Id psId, NavigableSet<Integer> allPsIds, ChangeKind kind) throws OrmException {
        int n = psa.getKey().getParentKey().get();
        Preconditions.checkArgument(n != psId.get());
        LabelType type = project.getLabelTypes().byLabel(psa.getLabelId());
        if (type == null) {
            return false;
        }
        if (Objects.equal(n, ApprovalCopier.previous(allPsIds, psId.get())) && (type.isCopyMinScore() && type.isMaxNegative(psa) || type.isCopyMaxScore() && type.isMaxPositive(psa))) {
            return true;
        }
        return type.isCopyAllScoresOnTrivialRebase() && kind == ChangeKind.TRIVIAL_REBASE || type.isCopyAllScoresIfNoCodeChange() && kind == ChangeKind.NO_CODE_CHANGE;
    }

    private static PatchSetApproval copy(PatchSetApproval src, PatchSet.Id psId) {
        if (src.getKey().getParentKey().equals(psId)) {
            return src;
        }
        return new PatchSetApproval(psId, src);
    }

    private static <T> T previous(NavigableSet<T> s, T v) {
        SortedSet<T> head = s.headSet(v);
        return !head.isEmpty() ? (T)head.last() : null;
    }
}

