/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Singleton
public class PatchLineCommentsUtil {
    private final NotesMigration migration;

    @Inject
    @VisibleForTesting
    public PatchLineCommentsUtil(NotesMigration migration) {
        this.migration = migration;
    }

    public List<PatchLineComment> publishedByChangeFile(ReviewDb db, ChangeNotes notes, Change.Id changeId, String file) throws OrmException {
        if (!this.migration.readPublishedComments()) {
            return db.patchComments().publishedByChangeFile(changeId, file).toList();
        }
        notes.load();
        ArrayList<PatchLineComment> commentsOnFile = new ArrayList<PatchLineComment>();
        PatchLineCommentsUtil.addCommentsInFile(commentsOnFile, notes.getBaseComments().values(), file);
        PatchLineCommentsUtil.addCommentsInFile(commentsOnFile, notes.getPatchSetComments().values(), file);
        Collections.sort(commentsOnFile, ChangeNotes.PatchLineCommentComparator);
        return commentsOnFile;
    }

    public List<PatchLineComment> publishedByPatchSet(ReviewDb db, ChangeNotes notes, PatchSet.Id psId) throws OrmException {
        if (!this.migration.readPublishedComments()) {
            return db.patchComments().publishedByPatchSet(psId).toList();
        }
        notes.load();
        ArrayList<PatchLineComment> commentsOnPs = new ArrayList<PatchLineComment>();
        commentsOnPs.addAll(notes.getPatchSetComments().get((Object)psId));
        commentsOnPs.addAll(notes.getBaseComments().get((Object)psId));
        return commentsOnPs;
    }

    private static Collection<PatchLineComment> addCommentsInFile(Collection<PatchLineComment> commentsOnFile, Collection<PatchLineComment> allComments, String file) {
        for (PatchLineComment c : allComments) {
            String currentFilename = c.getKey().getParentKey().getFileName();
            if (!currentFilename.equals(file)) continue;
            commentsOnFile.add(c);
        }
        return commentsOnFile;
    }

    public void addPublishedComments(ReviewDb db, ChangeUpdate update, Iterable<PatchLineComment> comments) throws OrmException {
        for (PatchLineComment c : comments) {
            update.putComment(c);
        }
        db.patchComments().upsert(comments);
    }
}

