/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.errors.InvalidUserNameException;
import com.google.gerrit.common.errors.NameAlreadyUsedException;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.ssh.SshKeyCache;
import com.google.gwtjsonrpc.common.VoidResult;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;

public class ChangeUserName
implements Callable<VoidResult> {
    private static final Pattern USER_NAME_PATTERN = Pattern.compile("^([a-zA-Z0-9][a-zA-Z0-9._-]*[a-zA-Z0-9]|[a-zA-Z0-9])$");
    private final AccountCache accountCache;
    private final SshKeyCache sshKeyCache;
    private final ReviewDb db;
    private final IdentifiedUser user;
    private final String newUsername;

    @Inject
    ChangeUserName(AccountCache accountCache, SshKeyCache sshKeyCache, @Assisted ReviewDb db, @Assisted IdentifiedUser user, @Nullable @Assisted String newUsername) {
        this.accountCache = accountCache;
        this.sshKeyCache = sshKeyCache;
        this.db = db;
        this.user = user;
        this.newUsername = newUsername;
    }

    @Override
    public VoidResult call() throws OrmException, NameAlreadyUsedException, InvalidUserNameException {
        Collection<AccountExternalId> old = this.old();
        if (!old.isEmpty()) {
            throw new IllegalStateException("Username cannot be changed.");
        }
        if (this.newUsername != null && !this.newUsername.isEmpty()) {
            if (!USER_NAME_PATTERN.matcher(this.newUsername).matches()) {
                throw new InvalidUserNameException();
            }
            AccountExternalId.Key key = new AccountExternalId.Key("username:", this.newUsername);
            try {
                AccountExternalId id = new AccountExternalId(this.user.getAccountId(), key);
                for (AccountExternalId i : old) {
                    if (i.getPassword() == null) continue;
                    id.setPassword(i.getPassword());
                }
                this.db.accountExternalIds().insert(Collections.singleton(id));
            }
            catch (OrmDuplicateKeyException dupeErr) {
                AccountExternalId other = this.db.accountExternalIds().get(key);
                if (other != null && other.getAccountId().equals(this.user.getAccountId())) {
                    return VoidResult.INSTANCE;
                }
                throw new NameAlreadyUsedException(this.newUsername);
            }
        }
        this.db.accountExternalIds().delete(old);
        for (AccountExternalId i : old) {
            this.sshKeyCache.evict(i.getSchemeRest());
            this.accountCache.evictByUsername(i.getSchemeRest());
        }
        this.accountCache.evict(this.user.getAccountId());
        this.accountCache.evictByUsername(this.newUsername);
        this.sshKeyCache.evict(this.newUsername);
        return VoidResult.INSTANCE;
    }

    private Collection<AccountExternalId> old() throws OrmException {
        ArrayList<AccountExternalId> r = new ArrayList<AccountExternalId>(1);
        for (AccountExternalId i : this.db.accountExternalIds().byAccount(this.user.getAccountId())) {
            if (!i.isScheme("username:")) continue;
            r.add(i);
        }
        return r;
    }

    public static interface Factory {
        public ChangeUserName create(ReviewDb var1, IdentifiedUser var2, String var3);
    }

    public static class CurrentUser {
        private final Factory factory;
        private final Provider<ReviewDb> db;
        private final Provider<IdentifiedUser> user;

        @Inject
        CurrentUser(Factory factory, Provider<ReviewDb> db, Provider<IdentifiedUser> user) {
            this.factory = factory;
            this.db = db;
            this.user = user;
        }

        public ChangeUserName create(String newUsername) {
            return this.factory.create(this.db.get(), this.user.get(), newUsername);
        }
    }
}

