/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.ssh.SshKeyCache;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collections;

@Singleton
public class DeleteSshKey
implements RestModifyView<AccountResource.SshKey, Input> {
    private final Provider<ReviewDb> dbProvider;
    private final SshKeyCache sshKeyCache;

    @Inject
    DeleteSshKey(Provider<ReviewDb> dbProvider, SshKeyCache sshKeyCache) {
        this.dbProvider = dbProvider;
        this.sshKeyCache = sshKeyCache;
    }

    public Response<?> apply(AccountResource.SshKey rsrc, Input input) throws OrmException {
        this.dbProvider.get().accountSshKeys().deleteKeys(Collections.singleton(rsrc.getSshKey().getKey()));
        this.sshKeyCache.evict(rsrc.getUser().getUserName());
        return Response.none();
    }

    public static class Input {
    }
}

