/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupIncludeCache;
import com.google.gerrit.server.account.GroupMembership;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class IncludingGroupMembership
implements GroupMembership {
    private final GroupIncludeCache includeCache;
    private final IdentifiedUser user;
    private final Map<AccountGroup.UUID, Boolean> memberOf;
    private Set<AccountGroup.UUID> knownGroups;

    @Inject
    IncludingGroupMembership(GroupIncludeCache includeCache, @Assisted IdentifiedUser user) {
        this.includeCache = includeCache;
        this.user = user;
        Set<AccountGroup.UUID> groups = user.state().getInternalGroups();
        this.memberOf = new ConcurrentHashMap<AccountGroup.UUID, Boolean>(groups.size());
        for (AccountGroup.UUID g : groups) {
            this.memberOf.put(g, true);
        }
    }

    @Override
    public boolean contains(AccountGroup.UUID id) {
        if (id == null) {
            return false;
        }
        Boolean b = this.memberOf.get(id);
        return b != null ? b.booleanValue() : this.containsAnyOf(ImmutableSet.of(id));
    }

    @Override
    public boolean containsAnyOf(Iterable<AccountGroup.UUID> queryIds) {
        boolean tryExpanding = false;
        for (AccountGroup.UUID id : queryIds) {
            Boolean b = this.memberOf.get(id);
            if (b == null) {
                tryExpanding = true;
                continue;
            }
            if (!b.booleanValue()) continue;
            return true;
        }
        if (tryExpanding) {
            for (AccountGroup.UUID id : queryIds) {
                if (this.memberOf.containsKey(id)) continue;
                this.memberOf.put(id, false);
                if (!this.search(this.includeCache.subgroupsOf(id))) continue;
                this.memberOf.put(id, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<AccountGroup.UUID> intersection(Iterable<AccountGroup.UUID> groupIds) {
        HashSet<AccountGroup.UUID> r = Sets.newHashSet();
        for (AccountGroup.UUID id : groupIds) {
            if (!this.contains(id)) continue;
            r.add(id);
        }
        return r;
    }

    private boolean search(Set<AccountGroup.UUID> ids) {
        return this.user.getEffectiveGroups().containsAnyOf(ids);
    }

    private ImmutableSet<AccountGroup.UUID> computeKnownGroups() {
        GroupMembership membership = this.user.getEffectiveGroups();
        Set<AccountGroup.UUID> direct = this.user.state().getInternalGroups();
        HashSet<AccountGroup.UUID> r = Sets.newHashSet(direct);
        r.remove(null);
        ArrayList<AccountGroup.UUID> q = Lists.newArrayList(r);
        for (AccountGroup.UUID g : membership.intersection(this.includeCache.allExternalMembers())) {
            if (g == null || !r.add(g)) continue;
            q.add(g);
        }
        while (!q.isEmpty()) {
            AccountGroup.UUID id = (AccountGroup.UUID)q.remove(q.size() - 1);
            for (AccountGroup.UUID g : this.includeCache.parentGroupsOf(id)) {
                if (g == null || !r.add(g)) continue;
                q.add(g);
                this.memberOf.put(g, true);
            }
        }
        return ImmutableSet.copyOf(r);
    }

    @Override
    public Set<AccountGroup.UUID> getKnownGroups() {
        if (this.knownGroups == null) {
            this.knownGroups = this.computeKnownGroups();
        }
        return this.knownGroups;
    }

    public static interface Factory {
        public IncludingGroupMembership create(IdentifiedUser var1);
    }
}

