/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Objects;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.TypeLiteral;
import org.eclipse.jgit.lib.ObjectId;

public class ChangeResource
implements RestResource,
RestResource.HasETag {
    public static final TypeLiteral<RestView<ChangeResource>> CHANGE_KIND = new TypeLiteral<RestView<ChangeResource>>(){};
    private final ChangeControl control;

    ChangeResource(ChangeControl control) {
        this.control = control;
    }

    protected ChangeResource(ChangeResource copy) {
        this.control = copy.control;
    }

    public ChangeControl getControl() {
        return this.control;
    }

    public Change getChange() {
        return this.getControl().getChange();
    }

    public ChangeNotes getNotes() {
        return this.getControl().getNotes();
    }

    @Override
    public String getETag() {
        CurrentUser user = this.control.getCurrentUser();
        Hasher h = Hashing.md5().newHasher().putLong(this.getChange().getLastUpdatedOn().getTime()).putInt(this.getChange().getRowVersion()).putBoolean(user.getStarredChanges().contains(this.getChange().getId())).putInt(user.isIdentifiedUser() ? ((IdentifiedUser)user).getAccountId().get() : 0);
        byte[] buf = new byte[20];
        for (ProjectState p : this.control.getProjectControl().getProjectState().tree()) {
            ObjectId id = p.getConfig().getRevision();
            Objects.firstNonNull(id, ObjectId.zeroId()).copyRawTo(buf, 0);
            h.putBytes(buf);
        }
        return h.hash().toString();
    }
}

