/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.cache.Cache;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsPost;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.CacheResource;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.ListCaches;
import com.google.gerrit.server.config.PostCaches;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@RequiresCapability(value="viewCaches")
@Singleton
public class CachesCollection
implements ChildCollection<ConfigResource, CacheResource>,
AcceptsPost<ConfigResource> {
    private final DynamicMap<RestView<CacheResource>> views;
    private final Provider<ListCaches> list;
    private final Provider<CurrentUser> self;
    private final DynamicMap<Cache<?, ?>> cacheMap;
    private final PostCaches postCaches;

    @Inject
    CachesCollection(DynamicMap<RestView<CacheResource>> views, Provider<ListCaches> list, Provider<CurrentUser> self, DynamicMap<Cache<?, ?>> cacheMap, PostCaches postCaches) {
        this.views = views;
        this.list = list;
        this.self = self;
        this.cacheMap = cacheMap;
        this.postCaches = postCaches;
    }

    @Override
    public RestView<ConfigResource> list() {
        return this.list.get();
    }

    @Override
    public CacheResource parse(ConfigResource parent, IdString id) throws AuthException, ResourceNotFoundException {
        Provider cacheProvider;
        CurrentUser user = this.self.get();
        if (user instanceof AnonymousUser) {
            throw new AuthException("Authentication required");
        }
        if (!user.isIdentifiedUser()) {
            throw new ResourceNotFoundException();
        }
        if (!user.getCapabilities().canViewCaches()) {
            throw new AuthException("not allowed to view caches");
        }
        String cacheName = id.get();
        String pluginName = "gerrit";
        int i = cacheName.lastIndexOf(45);
        if (i != -1) {
            pluginName = cacheName.substring(0, i);
            String string = cacheName = cacheName.length() > i + 1 ? cacheName.substring(i + 1) : "";
        }
        if ((cacheProvider = (Provider)this.cacheMap.byPlugin(pluginName).get(cacheName)) == null) {
            throw new ResourceNotFoundException(id);
        }
        return new CacheResource(pluginName, cacheName, cacheProvider);
    }

    @Override
    public DynamicMap<RestView<CacheResource>> views() {
        return this.views;
    }

    public PostCaches post(ConfigResource parent) throws RestApiException {
        return this.postCaches;
    }
}

