/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.RequestCleanup;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.servlet.RequestScoped;

@RequestScoped
public class RequestScopedReviewDbProvider
implements Provider<ReviewDb> {
    private final SchemaFactory<ReviewDb> schema;
    private final Provider<RequestCleanup> cleanup;
    private ReviewDb db;

    @Inject
    public RequestScopedReviewDbProvider(SchemaFactory<ReviewDb> schema, Provider<RequestCleanup> cleanup) {
        this.schema = schema;
        this.cleanup = cleanup;
    }

    @Override
    public ReviewDb get() {
        if (this.db == null) {
            ReviewDb c;
            try {
                c = this.schema.open();
            }
            catch (OrmException e) {
                throw new ProvisionException("Cannot open ReviewDb", e);
            }
            try {
                this.cleanup.get().add(new Runnable(){

                    @Override
                    public void run() {
                        c.close();
                        RequestScopedReviewDbProvider.this.db = null;
                    }
                });
            }
            catch (Throwable e) {
                c.close();
                throw new ProvisionException("Cannot defer cleanup of ReviewDb", e);
            }
            this.db = c;
        }
        return this.db;
    }
}

