/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.account.GetPreferences;
import com.google.gerrit.server.account.SetPreferences;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;

@RequiresCapability(value="administrateServer")
@Singleton
public class SetPreferences
implements RestModifyView<ConfigResource, SetPreferences.Input> {
    private final MetaDataUpdate.User metaDataUpdateFactory;
    private final AllUsersName allUsersName;

    @Inject
    SetPreferences(MetaDataUpdate.User metaDataUpdateFactory, AllUsersName allUsersName) {
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.allUsersName = allUsersName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object apply(ConfigResource rsrc, SetPreferences.Input i) throws BadRequestException, IOException, ConfigInvalidException {
        if (i.changesPerPage != null || i.showSiteHeader != null || i.useFlashClipboard != null || i.downloadScheme != null || i.downloadCommand != null || i.copySelfOnEmail != null || i.dateFormat != null || i.timeFormat != null || i.reversePatchSetOrder != null || i.relativeDateInChangeTable != null || i.sizeBarInChangeTable != null || i.legacycidInChangeTable != null || i.reviewCategoryStrategy != null || i.commentVisibilityStrategy != null || i.diffView != null || i.changeScreen != null) {
            throw new BadRequestException("unsupported option");
        }
        try (MetaDataUpdate md = this.metaDataUpdateFactory.create(this.allUsersName);){
            VersionedAccountPreferences p = VersionedAccountPreferences.forDefault();
            p.load(md);
            com.google.gerrit.server.account.SetPreferences.storeMyMenus(p, i.my);
            p.commit(md);
            GetPreferences.PreferenceInfo preferenceInfo = new GetPreferences.PreferenceInfo(null, p, md.getRepository());
            return preferenceInfo;
        }
    }
}

