/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.contact;

import com.google.gerrit.common.errors.ContactInformationStoreException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.client.ContactInformation;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.UrlEncoded;
import com.google.gerrit.server.contact.ContactStore;
import com.google.gerrit.server.contact.ContactStoreConnection;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class EncryptedContactStore
implements ContactStore {
    private static final Logger log = LoggerFactory.getLogger(EncryptedContactStore.class);
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final SchemaFactory<ReviewDb> schema;
    private final PGPPublicKey dest;
    private final SecureRandom prng;
    private final URL storeUrl;
    private final String storeAPPSEC;
    private final ContactStoreConnection.Factory connFactory;

    EncryptedContactStore(URL storeUrl, String storeAPPSEC, File pubKey, SchemaFactory<ReviewDb> schema, ContactStoreConnection.Factory connFactory) {
        this.storeUrl = storeUrl;
        this.storeAPPSEC = storeAPPSEC;
        this.schema = schema;
        this.dest = EncryptedContactStore.selectKey(EncryptedContactStore.readPubRing(pubKey));
        this.connFactory = connFactory;
        String prngName = "SHA1PRNG";
        try {
            this.prng = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProvisionException("Cannot create SHA1PRNG", e);
        }
        try {
            this.encrypt("test", new Date(0L), "test".getBytes("UTF-8"));
        }
        catch (IOException | PGPException e) {
            throw new ProvisionException("PGP encryption not available", e);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    /*
     * Exception decompiling
     */
    private static PGPPublicKeyRingCollection readPubRing(File pub) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static PGPPublicKey selectKey(PGPPublicKeyRingCollection rings) {
        Iterator ri = rings.getKeyRings();
        while (ri.hasNext()) {
            PGPPublicKeyRing currRing = (PGPPublicKeyRing)ri.next();
            Iterator ki = currRing.getPublicKeys();
            while (ki.hasNext()) {
                PGPPublicKey k = (PGPPublicKey)ki.next();
                if (!k.isEncryptionKey()) continue;
                return k;
            }
        }
        return null;
    }

    @Override
    public void store(Account account, ContactInformation info) throws ContactInformationStoreException {
        try {
            byte[] plainText = this.format(account, info).getBytes("UTF-8");
            String fileName = "account-" + account.getId();
            Timestamp fileDate = account.getContactFiledOn();
            byte[] encText = this.encrypt(fileName, fileDate, plainText);
            String encStr = new String(encText, "UTF-8");
            Timestamp filedOn = account.getContactFiledOn();
            UrlEncoded u = new UrlEncoded();
            if (this.storeAPPSEC != null) {
                u.put("APPSEC", this.storeAPPSEC);
            }
            if (account.getPreferredEmail() != null) {
                u.put("email", account.getPreferredEmail());
            }
            if (filedOn != null) {
                u.put("filed", String.valueOf(filedOn.getTime() / 1000L));
            }
            u.put("account_id", String.valueOf(account.getId().get()));
            u.put("data", encStr);
            this.connFactory.open(this.storeUrl).store(u.toString().getBytes("UTF-8"));
        }
        catch (IOException | PGPException e) {
            log.error("Cannot store encrypted contact information", e);
            throw new ContactInformationStoreException(e);
        }
    }

    private final PGPEncryptedDataGenerator cpk() {
        BcPGPDataEncryptorBuilder builder = new BcPGPDataEncryptorBuilder(3).setSecureRandom(this.prng);
        PGPEncryptedDataGenerator cpk = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)builder, true);
        BcPublicKeyKeyEncryptionMethodGenerator methodGenerator = new BcPublicKeyKeyEncryptionMethodGenerator(this.dest);
        cpk.addMethod((PGPKeyEncryptionMethodGenerator)methodGenerator);
        return cpk;
    }

    private byte[] encrypt(String name, Date date, byte[] rawText) throws PGPException, IOException {
        byte[] zText = EncryptedContactStore.compress(name, date, rawText);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ArmoredOutputStream aout = new ArmoredOutputStream((OutputStream)buf);
        OutputStream cout = this.cpk().open((OutputStream)aout, (long)zText.length);
        cout.write(zText);
        cout.close();
        aout.close();
        return buf.toByteArray();
    }

    private static byte[] compress(String fileName, Date fileDate, byte[] plainText) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int len = plainText.length;
        if (fileDate == null) {
            fileDate = PGPLiteralData.NOW;
        }
        PGPCompressedDataGenerator comdg = new PGPCompressedDataGenerator(1);
        OutputStream out = new PGPLiteralDataGenerator().open(comdg.open((OutputStream)buf), 'b', fileName, (long)len, fileDate);
        out.write(plainText);
        out.close();
        comdg.close();
        return buf.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String format(Account account, ContactInformation info) throws ContactInformationStoreException {
        Timestamp on = account.getContactFiledOn();
        if (on == null) {
            on = TimeUtil.nowTs();
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        df.setTimeZone(UTC);
        StringBuilder b = new StringBuilder();
        EncryptedContactStore.field(b, "Account-Id", account.getId().toString());
        EncryptedContactStore.field(b, "Date", df.format(on) + " " + UTC.getID());
        EncryptedContactStore.field(b, "Full-Name", account.getFullName());
        EncryptedContactStore.field(b, "Preferred-Email", account.getPreferredEmail());
        try (ReviewDb db = this.schema.open();){
            for (AccountExternalId e : db.accountExternalIds().byAccount(account.getId())) {
                StringBuilder oistr = new StringBuilder();
                if (e.getEmailAddress() != null && e.getEmailAddress().length() > 0) {
                    if (oistr.length() > 0) {
                        oistr.append(' ');
                    }
                    oistr.append(e.getEmailAddress());
                }
                if (e.isScheme("mailto:")) {
                    if (oistr.length() > 0) {
                        oistr.append(' ');
                    }
                    oistr.append('<');
                    oistr.append(e.getExternalId());
                    oistr.append('>');
                }
                EncryptedContactStore.field(b, "Identity", oistr.toString());
            }
        }
        catch (OrmException e) {
            throw new ContactInformationStoreException(e);
        }
        EncryptedContactStore.field(b, "Address", info.getAddress());
        EncryptedContactStore.field(b, "Country", info.getCountry());
        EncryptedContactStore.field(b, "Phone-Number", info.getPhoneNumber());
        EncryptedContactStore.field(b, "Fax-Number", info.getFaxNumber());
        return b.toString();
    }

    private static void field(StringBuilder b, String name, String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        b.append(name);
        b.append(':');
        if (value.indexOf(10) == -1) {
            b.append(' ');
            b.append(value);
        } else {
            value = value.replaceAll("\r\n", "\n");
            value = value.replaceAll("\n", "\n\t");
            b.append("\n\t");
            b.append(value);
        }
        b.append('\n');
    }
}

