/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.common.collect.Lists;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetAncestor;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.CommitMergeStatus;
import com.google.gerrit.server.git.MergeException;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevCommit;

public class CherryPick
extends SubmitStrategy {
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final GitReferenceUpdated gitRefUpdated;
    private final Map<Change.Id, CodeReviewCommit> newCommits;

    CherryPick(SubmitStrategy.Arguments args, PatchSetInfoFactory patchSetInfoFactory, GitReferenceUpdated gitRefUpdated) {
        super(args);
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.gitRefUpdated = gitRefUpdated;
        this.newCommits = new HashMap<Change.Id, CodeReviewCommit>();
    }

    @Override
    protected CodeReviewCommit _run(CodeReviewCommit mergeTip, List<CodeReviewCommit> toMerge) throws MergeException {
        while (!toMerge.isEmpty()) {
            CodeReviewCommit n = toMerge.remove(0);
            try {
                if (mergeTip == null) {
                    mergeTip = n;
                    n.setStatusCode(CommitMergeStatus.CLEAN_MERGE);
                    continue;
                }
                if (n.getParentCount() == 0) {
                    n.setStatusCode(CommitMergeStatus.CANNOT_CHERRY_PICK_ROOT);
                    continue;
                }
                if (n.getParentCount() == 1) {
                    if ((mergeTip = this.writeCherryPickCommit(mergeTip, n)) != null) {
                        this.newCommits.put(mergeTip.getPatchsetId().getParentKey(), mergeTip);
                        continue;
                    }
                    n.setStatusCode(CommitMergeStatus.PATH_CONFLICT);
                    continue;
                }
                if (this.args.mergeUtil.hasMissingDependencies(this.args.mergeSorter, n)) continue;
                mergeTip = this.args.rw.isMergedInto(mergeTip, n) ? n : this.args.mergeUtil.mergeOneCommit(this.args.serverIdent.get(), this.args.repo, this.args.rw, this.args.inserter, this.args.canMergeFlag, this.args.destBranch, mergeTip, n);
                PatchSetApproval submitApproval = this.args.mergeUtil.markCleanMerges(this.args.rw, this.args.canMergeFlag, mergeTip, this.args.alreadyAccepted);
                this.setRefLogIdent(submitApproval);
            }
            catch (NoSuchChangeException | OrmException | IOException e) {
                throw new MergeException("Cannot merge " + n.name(), e);
            }
        }
        return mergeTip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodeReviewCommit writeCherryPickCommit(CodeReviewCommit mergeTip, CodeReviewCommit n) throws IOException, OrmException, NoSuchChangeException {
        RefUpdate ru;
        PersonIdent cherryPickCommitterIdent;
        IdentifiedUser cherryPickUser;
        this.args.rw.parseBody(n);
        PatchSetApproval submitAudit = this.args.mergeUtil.getSubmitter(n);
        PersonIdent serverNow = this.args.serverIdent.get();
        if (submitAudit != null) {
            cherryPickUser = this.args.identifiedUserFactory.create(submitAudit.getAccountId());
            cherryPickCommitterIdent = cherryPickUser.newCommitterIdent(serverNow.getWhen(), serverNow.getTimeZone());
        } else {
            cherryPickUser = this.args.identifiedUserFactory.create(n.change().getOwner());
            cherryPickCommitterIdent = serverNow;
        }
        String cherryPickCmtMsg = this.args.mergeUtil.createCherryPickCommitMessage(n);
        CodeReviewCommit newCommit = (CodeReviewCommit)this.args.mergeUtil.createCherryPickFromCommit(this.args.repo, this.args.inserter, mergeTip, n, cherryPickCommitterIdent, cherryPickCmtMsg, this.args.rw);
        if (newCommit == null) {
            return null;
        }
        PatchSet.Id id = ChangeUtil.nextPatchSetId(this.args.repo, n.change().currentPatchSetId());
        PatchSet ps = new PatchSet(id);
        ps.setCreatedOn(TimeUtil.nowTs());
        ps.setUploader(cherryPickUser.getAccountId());
        ps.setRevision(new RevId(newCommit.getId().getName()));
        this.args.db.changes().beginTransaction(n.change().getId());
        try {
            CherryPick.insertAncestors(this.args.db, ps.getId(), newCommit);
            this.args.db.patchSets().insert(Collections.singleton(ps));
            n.change().setCurrentPatchSet(this.patchSetInfoFactory.get(newCommit, ps.getId()));
            this.args.db.changes().update(Collections.singletonList(n.change()));
            ArrayList<PatchSetApproval> approvals = Lists.newArrayList();
            for (PatchSetApproval a : this.args.approvalsUtil.byPatchSet(this.args.db, n.getControl(), n.getPatchsetId())) {
                approvals.add(new PatchSetApproval(ps.getId(), a));
            }
            this.args.db.patchSetApprovals().insert(approvals);
            ru = this.args.repo.updateRef(ps.getRefName());
            ru.setExpectedOldObjectId(ObjectId.zeroId());
            ru.setNewObjectId(newCommit);
            ru.disableRefLog();
            if (ru.update(this.args.rw) != RefUpdate.Result.NEW) {
                throw new IOException(String.format("Failed to create ref %s in %s: %s", new Object[]{ps.getRefName(), n.change().getDest().getParentKey().get(), ru.getResult()}));
            }
            this.args.db.commit();
        }
        finally {
            this.args.db.rollback();
        }
        this.gitRefUpdated.fire(n.change().getProject(), ru);
        newCommit.copyFrom(n);
        newCommit.setStatusCode(CommitMergeStatus.CLEAN_PICK);
        newCommit.setControl(this.args.changeControlFactory.controlFor(n.change(), cherryPickUser));
        this.newCommits.put(newCommit.getPatchsetId().getParentKey(), newCommit);
        this.setRefLogIdent(submitAudit);
        return newCommit;
    }

    private static void insertAncestors(ReviewDb db, PatchSet.Id id, RevCommit src) throws OrmException {
        int cnt = src.getParentCount();
        ArrayList<PatchSetAncestor> toInsert = new ArrayList<PatchSetAncestor>(cnt);
        for (int p = 0; p < cnt; ++p) {
            PatchSetAncestor a = new PatchSetAncestor(new PatchSetAncestor.Id(id, p + 1));
            a.setAncestorRevision(new RevId(src.getParent(p).getId().name()));
            toInsert.add(a);
        }
        db.patchSetAncestors().insert(toInsert);
    }

    @Override
    public Map<Change.Id, CodeReviewCommit> getNewCommits() {
        return this.newCommits;
    }

    @Override
    public boolean dryRun(CodeReviewCommit mergeTip, CodeReviewCommit toMerge) throws MergeException {
        return this.args.mergeUtil.canCherryPick(this.args.mergeSorter, this.args.repo, mergeTip, this.args.rw, toMerge);
    }
}

