/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.base.Preconditions;
import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.FieldDef;
import com.google.gerrit.server.index.FieldType;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.index.Schema;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtjsonrpc.common.JavaSqlTimestampHelper;
import java.sql.Timestamp;
import java.util.Date;

public abstract class TimestampRangePredicate<I>
extends IndexPredicate<I> {
    protected static FieldDef<ChangeData, Timestamp> updatedField(Schema<ChangeData> schema) {
        if (schema == null) {
            return ChangeField.LEGACY_UPDATED;
        }
        FieldDef<ChangeData, Timestamp> f = schema.getFields().get(ChangeField.UPDATED.getName());
        if (f == null) {
            f = schema.getFields().get(ChangeField.LEGACY_UPDATED.getName());
            Preconditions.checkNotNull(f, "schema missing updated field, found: %s", schema);
        }
        Preconditions.checkArgument(f.getType() == FieldType.TIMESTAMP, "expected %s to be TIMESTAMP, found %s", f.getName(), f.getType());
        return f;
    }

    protected static Timestamp parse(String value) throws QueryParseException {
        try {
            return JavaSqlTimestampHelper.parseTimestamp(value);
        }
        catch (IllegalArgumentException e) {
            throw new QueryParseException(e.getMessage(), e);
        }
    }

    protected TimestampRangePredicate(FieldDef<I, Timestamp> def, String name, String value) {
        super(def, name, value);
    }

    public abstract Date getMinTimestamp();

    public abstract Date getMaxTimestamp();

    @Override
    public int getCost() {
        return 1;
    }
}

