/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.gerrit.server.plugins.ServerPluginProvider;
import java.io.File;

class MultipleProvidersForPluginException
extends IllegalArgumentException {
    private static final long serialVersionUID = 1L;

    MultipleProvidersForPluginException(File pluginSrcFile, Iterable<ServerPluginProvider> providersHandlers) {
        super(pluginSrcFile.getAbsolutePath() + " is claimed to be handled by more than one plugin provider: " + MultipleProvidersForPluginException.providersListToString(providersHandlers));
    }

    private static String providersListToString(Iterable<ServerPluginProvider> providersHandlers) {
        Iterable<String> providerNames = Iterables.transform(providersHandlers, new Function<ServerPluginProvider, String>(){

            @Override
            public String apply(ServerPluginProvider provider) {
                return provider.getProviderPluginName();
            }
        });
        return Joiner.on(", ").join(providerNames);
    }
}

