/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gerrit.common.data.SubmitTypeRecord;
import com.google.gerrit.extensions.common.SubmitType;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.MergeException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.OperatorPredicate;
import com.google.gerrit.server.query.OrPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.EqualsPathPredicate;
import com.google.gerrit.server.query.change.LegacyChangeIdPredicate;
import com.google.gerrit.server.query.change.ProjectPredicate;
import com.google.gerrit.server.query.change.RefPredicate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

class ConflictsPredicate
extends OrPredicate<ChangeData> {
    private final String value;

    ConflictsPredicate(ChangeQueryBuilder.Arguments args, String value, List<Change> changes) throws OrmException {
        super(ConflictsPredicate.predicates(args, value, changes));
        this.value = value;
    }

    private static List<Predicate<ChangeData>> predicates(final ChangeQueryBuilder.Arguments args, String value, List<Change> changes) throws OrmException {
        ArrayList<Predicate<ChangeData>> changePredicates = Lists.newArrayListWithCapacity(changes.size());
        final Provider<ReviewDb> db = args.db;
        for (final Change c : changes) {
            final ChangeDataCache changeDataCache = new ChangeDataCache(c, db, args.changeDataFactory, args.projectCache);
            List<String> files = args.changeDataFactory.create(db.get(), c).currentFilePaths();
            ArrayList<EqualsPathPredicate> filePredicates = Lists.newArrayListWithCapacity(files.size());
            for (String file : files) {
                filePredicates.add(new EqualsPathPredicate("path", file));
            }
            ArrayList predicatesForOneChange = Lists.newArrayListWithCapacity(5);
            predicatesForOneChange.add(ConflictsPredicate.not(new LegacyChangeIdPredicate(args, c.getId())));
            predicatesForOneChange.add(new ProjectPredicate(c.getProject().get()));
            predicatesForOneChange.add(new RefPredicate(c.getDest().get()));
            predicatesForOneChange.add(ConflictsPredicate.or(filePredicates));
            predicatesForOneChange.add(new OperatorPredicate<ChangeData>("conflicts", value){

                /*
                 * Exception decompiling
                 */
                @Override
                public boolean match(ChangeData object) throws OrmException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @Override
                public int getCost() {
                    return 5;
                }

                private SubmitType getSubmitType(Change change, ChangeData cd) throws OrmException {
                    try {
                        SubmitTypeRecord r = args.changeControlGenericFactory.controlFor(change, args.userFactory.create(change.getOwner())).getSubmitTypeRecord((ReviewDb)db.get(), cd.currentPatchSet(), cd);
                        if (r.status != SubmitTypeRecord.Status.OK) {
                            return null;
                        }
                        return r.type;
                    }
                    catch (NoSuchChangeException e) {
                        return null;
                    }
                }

                private Set<RevCommit> getAlreadyAccepted(Repository repo, RevWalk rw, CodeReviewCommit tip) throws MergeException {
                    HashSet<RevCommit> alreadyAccepted = Sets.newHashSet();
                    if (tip != null) {
                        alreadyAccepted.add(tip);
                    }
                    try {
                        for (ObjectId id : changeDataCache.getAlreadyAccepted(repo)) {
                            try {
                                alreadyAccepted.add(rw.parseCommit(id));
                            }
                            catch (IncorrectObjectTypeException iote) {}
                        }
                    }
                    catch (IOException e) {
                        throw new MergeException("Failed to determine already accepted commits.", e);
                    }
                    return alreadyAccepted;
                }
            });
            changePredicates.add(ConflictsPredicate.and(predicatesForOneChange));
        }
        return changePredicates;
    }

    @Override
    public String toString() {
        return "conflicts:" + this.value;
    }

    private static class ChangeDataCache {
        private final Change change;
        private final Provider<ReviewDb> db;
        private final ChangeData.Factory changeDataFactory;
        private final ProjectCache projectCache;
        private ObjectId testAgainst;
        private ProjectState projectState;
        private Set<ObjectId> alreadyAccepted;

        ChangeDataCache(Change change, Provider<ReviewDb> db, ChangeData.Factory changeDataFactory, ProjectCache projectCache) {
            this.change = change;
            this.db = db;
            this.changeDataFactory = changeDataFactory;
            this.projectCache = projectCache;
        }

        ObjectId getTestAgainst() throws OrmException {
            if (this.testAgainst == null) {
                this.testAgainst = ObjectId.fromString(this.changeDataFactory.create(this.db.get(), this.change).currentPatchSet().getRevision().get());
            }
            return this.testAgainst;
        }

        ProjectState getProjectState() {
            if (this.projectState == null) {
                this.projectState = this.projectCache.get(this.change.getProject());
                if (this.projectState == null) {
                    throw new IllegalStateException(new NoSuchProjectException(this.change.getProject()));
                }
            }
            return this.projectState;
        }

        Set<ObjectId> getAlreadyAccepted(Repository repo) {
            if (this.alreadyAccepted == null) {
                this.alreadyAccepted = Sets.newHashSet();
                for (Ref r : repo.getAllRefs().values()) {
                    if (!r.getName().startsWith("refs/heads/") && !r.getName().startsWith("refs/tags/") || r.getObjectId() == null) continue;
                    this.alreadyAccepted.add(r.getObjectId());
                }
            }
            return this.alreadyAccepted;
        }
    }
}

