/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.ChangeCache;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.TransferConfig;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.server.git.validators.UploadValidationException;
import com.google.gerrit.server.git.validators.UploadValidators;
import com.google.gerrit.sshd.AbstractGitCommand;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.SshSession;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jgit.transport.PreUploadHook;
import org.eclipse.jgit.transport.PreUploadHookChain;
import org.eclipse.jgit.transport.UploadPack;

final class Upload
extends AbstractGitCommand {
    @Inject
    private Provider<ReviewDb> db;
    @Inject
    private TransferConfig config;
    @Inject
    private TagCache tagCache;
    @Inject
    private ChangeCache changeCache;
    @Inject
    private DynamicSet<PreUploadHook> preUploadHooks;
    @Inject
    private UploadValidators.Factory uploadValidatorsFactory;
    @Inject
    private SshSession session;

    Upload() {
    }

    @Override
    protected void runImpl() throws IOException, BaseCommand.Failure {
        block4: {
            if (!this.projectControl.canRunUploadPack()) {
                throw new BaseCommand.Failure(1, "fatal: upload-pack not permitted on this server");
            }
            UploadPack up = new UploadPack(this.repo);
            if (!this.projectControl.allRefsAreVisible()) {
                up.setAdvertiseRefsHook(new VisibleRefFilter(this.tagCache, this.changeCache, this.repo, this.projectControl, this.db.get(), true));
            }
            up.setPackConfig(this.config.getPackConfig());
            up.setTimeout(this.config.getTimeout());
            ArrayList<PreUploadHook> allPreUploadHooks = Lists.newArrayList(this.preUploadHooks);
            allPreUploadHooks.add(this.uploadValidatorsFactory.create(this.project, this.repo, this.session.getRemoteAddressAsString()));
            up.setPreUploadHook(PreUploadHookChain.newChain(allPreUploadHooks));
            try {
                up.upload(this.in, this.out, this.err);
            }
            catch (UploadValidationException e) {
                if (e.isOutput()) break block4;
                up.sendMessage(e.getMessage());
            }
        }
    }
}

