/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionMimeDetector
extends MimeDetector {
    private static Logger log;
    private static Map extMimeTypes;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("eu.medsea.mimeutil.detector.ExtensionMimeDetector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger(clazz);
    }

    public ExtensionMimeDetector() {
        ExtensionMimeDetector.initMimeTypes();
    }

    public String getDescription() {
        return "Get the mime types of file extensions";
    }

    public Collection getMimeTypesFile(File file) throws MimeException {
        return this.getMimeTypesFileName(file.getName());
    }

    public Collection getMimeTypesURL(URL url) throws MimeException {
        return this.getMimeTypesFileName(url.getPath());
    }

    public Collection getMimeTypesFileName(String fileName) throws MimeException {
        HashSet<MimeType> mimeTypes = new HashSet<MimeType>();
        String fileExtension = MimeUtil.getExtension(fileName);
        while (fileExtension.length() != 0) {
            String types = null;
            types = (String)extMimeTypes.get(fileExtension);
            if (types != null) {
                String[] mimeTypeArray = types.split(",");
                int i = 0;
                while (i < mimeTypeArray.length) {
                    mimeTypes.add(new MimeType(mimeTypeArray[i]));
                    ++i;
                }
                return mimeTypes;
            }
            if (mimeTypes.isEmpty() && (types = (String)extMimeTypes.get(fileExtension.toLowerCase())) != null) {
                String[] mimeTypeArray = types.split(",");
                int i = 0;
                while (i < mimeTypeArray.length) {
                    mimeTypes.add(new MimeType(mimeTypeArray[i]));
                    ++i;
                }
                return mimeTypes;
            }
            fileExtension = MimeUtil.getExtension(fileExtension);
        }
        return mimeTypes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initMimeTypes() {
        Iterator it;
        InputStream is = null;
        extMimeTypes = new Properties();
        try {
            Properties props;
            block43: {
                block41: {
                    block39: {
                        try {
                            try {
                                Class<?> clazz = class$1;
                                if (clazz == null) {
                                    Class<?> clazz2;
                                    try {
                                        clazz2 = Class.forName("eu.medsea.mimeutil.MimeUtil");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    clazz = class$1 = clazz2;
                                }
                                if ((is = clazz.getClassLoader().getResourceAsStream("eu/medsea/mimeutil/mime-types.properties")) != null) {
                                    ((Properties)extMimeTypes).load(is);
                                }
                            }
                            catch (Exception e) {
                                log.error("Error loading internal mime-types.properties", e);
                                is = ExtensionMimeDetector.closeStream(is);
                                break block39;
                            }
                        }
                        catch (Throwable throwable) {
                            is = ExtensionMimeDetector.closeStream(is);
                            throw throwable;
                        }
                        is = ExtensionMimeDetector.closeStream(is);
                    }
                    try {
                        try {
                            File f = new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".mime-types.properties");
                            if (f.exists() && (is = new FileInputStream(f)) != null) {
                                log.debug("Found a custom .mime-types.properties file in the users home directory.");
                                props = new Properties();
                                props.load(is);
                                if (props.size() > 0) {
                                    extMimeTypes.putAll(props);
                                }
                                log.debug("Successfully parsed .mime-types.properties from users home directory.");
                            }
                        }
                        catch (Exception e) {
                            log.error("Failed to parse .magic.mime file from users home directory. File will be ignored.", e);
                            is = ExtensionMimeDetector.closeStream(is);
                            break block41;
                        }
                    }
                    catch (Throwable throwable) {
                        is = ExtensionMimeDetector.closeStream(is);
                        throw throwable;
                    }
                    is = ExtensionMimeDetector.closeStream(is);
                }
                try {
                    try {
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            Class<?> clazz3;
                            try {
                                clazz3 = Class.forName("eu.medsea.mimeutil.MimeUtil");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz = class$1 = clazz3;
                        }
                        Enumeration<URL> e = clazz.getClassLoader().getResources("mime-types.properties");
                        while (e.hasMoreElements()) {
                            URL url = e.nextElement();
                            if (log.isDebugEnabled()) {
                                log.debug("Found custom mime-types.properties file on the classpath [" + url + "].");
                            }
                            Properties props2 = new Properties();
                            try {
                                is = url.openStream();
                                if (is == null) continue;
                                props2.load(is);
                                if (props2.size() <= 0) continue;
                                extMimeTypes.putAll(props2);
                                if (!log.isDebugEnabled()) continue;
                                log.debug("Successfully loaded custome mime-type.properties file [" + url + "] from classpath.");
                            }
                            catch (Exception ex) {
                                log.error("Failed while loading custom mime-type.properties file [" + url + "] from classpath. File will be ignored.");
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("Problem while processing mime-types.properties files(s) from classpath. Files will be ignored.", e);
                        is = ExtensionMimeDetector.closeStream(is);
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    is = ExtensionMimeDetector.closeStream(is);
                    throw throwable;
                }
                is = ExtensionMimeDetector.closeStream(is);
            }
            try {
                try {
                    String fname = System.getProperty("mime-mappings");
                    if (fname != null && fname.length() != 0 && (is = new FileInputStream(fname)) != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Found a custom mime-mappings property defined by the property -Dmime-mappings [" + System.getProperty("mime-mappings") + "].");
                        }
                        props = new Properties();
                        props.load(is);
                        if (props.size() > 0) {
                            extMimeTypes.putAll(props);
                        }
                        log.debug("Successfully loaded the mime mappings file from property -Dmime-mappings [" + System.getProperty("mime-mappings") + "].");
                    }
                }
                catch (Exception ex) {
                    log.error("Failed to load the mime-mappings file defined by the property -Dmime-mappings [" + System.getProperty("mime-mappings") + "].");
                    is = ExtensionMimeDetector.closeStream(is);
                }
            }
            catch (Throwable throwable) {
                is = ExtensionMimeDetector.closeStream(is);
                throw throwable;
            }
            is = ExtensionMimeDetector.closeStream(is);
        }
        finally {
            it = extMimeTypes.values().iterator();
        }
        block26: while (it.hasNext()) {
            String[] types = ((String)it.next()).split(",");
            int i = 0;
            while (true) {
                if (i >= types.length) continue block26;
                MimeUtil.addKnownMimeType(types[i]);
                ++i;
            }
            break;
        }
        return;
    }

    public Collection getMimeTypesInputStream(InputStream in) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This MimeDetector does not support detection from streams.");
    }

    public Collection getMimeTypesByteArray(byte[] data) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This MimeDetector does not support detection from byte arrays.");
    }
}

