/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class CreateBranchCommand
extends GitCommand<Ref> {
    private String name;
    private boolean force = false;
    private SetupUpstreamMode upstreamMode;
    private String startPoint = "HEAD";
    private RevCommit startCommit;

    protected CreateBranchCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Ref call() throws GitAPIException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException {
        this.checkCallable();
        this.processOptions();
        RevWalk revWalk = new RevWalk(this.repo);
        try {
            String autosetupflag;
            String refLogMessage;
            Ref baseRef;
            boolean exists;
            Ref refToCheck = this.repo.getRef(this.name);
            boolean bl = exists = refToCheck != null && refToCheck.getName().startsWith("refs/heads/");
            if (!this.force && exists) {
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().refAlreadyExists1, this.name));
            }
            ObjectId startAt = this.getStartPointObjectId();
            String startPointFullName = null;
            if (this.startPoint != null && (baseRef = this.repo.getRef(this.startPoint)) != null) {
                startPointFullName = baseRef.getName();
            }
            String baseBranch = "";
            if (startPointFullName == null) {
                String baseCommit;
                if (this.startCommit != null) {
                    baseCommit = this.startCommit.getShortMessage();
                } else {
                    RevCommit commit = revWalk.parseCommit(this.repo.resolve(this.getStartPointOrHead()));
                    baseCommit = commit.getShortMessage();
                }
                if (exists) {
                    String string = String.valueOf(baseCommit);
                    refLogMessage = string.length() != 0 ? "branch: Reset start-point to commit ".concat(string) : new String("branch: Reset start-point to commit ");
                } else {
                    String string = String.valueOf(baseCommit);
                    refLogMessage = string.length() != 0 ? "branch: Created from commit ".concat(string) : new String("branch: Created from commit ");
                }
            } else if (startPointFullName.startsWith("refs/heads/") || startPointFullName.startsWith("refs/remotes/")) {
                baseBranch = startPointFullName;
                if (exists) {
                    String string = String.valueOf(startPointFullName);
                    refLogMessage = string.length() != 0 ? "branch: Reset start-point to branch ".concat(string) : new String("branch: Reset start-point to branch ");
                } else {
                    String string = String.valueOf(baseBranch);
                    refLogMessage = string.length() != 0 ? "branch: Created from branch ".concat(string) : new String("branch: Created from branch ");
                }
            } else {
                startAt = revWalk.peel(revWalk.parseAny(startAt));
                if (exists) {
                    String string = String.valueOf(startPointFullName);
                    refLogMessage = string.length() != 0 ? "branch: Reset start-point to tag ".concat(string) : new String("branch: Reset start-point to tag ");
                } else {
                    String string = String.valueOf(startPointFullName);
                    refLogMessage = string.length() != 0 ? "branch: Created from tag ".concat(string) : new String("branch: Created from tag ");
                }
            }
            String string = String.valueOf("refs/heads/");
            String string2 = String.valueOf(this.name);
            RefUpdate updateRef = this.repo.updateRef(string2.length() != 0 ? string.concat(string2) : new String(string));
            updateRef.setNewObjectId(startAt);
            updateRef.setRefLogMessage(refLogMessage, false);
            RefUpdate.Result updateResult = exists && this.force ? updateRef.forceUpdate() : updateRef.update();
            this.setCallable(false);
            boolean ok = false;
            switch (updateResult) {
                case NEW: {
                    ok = !exists;
                    break;
                }
                case NO_CHANGE: 
                case FAST_FORWARD: 
                case FORCED: {
                    ok = exists;
                    break;
                }
            }
            if (!ok) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().createBranchUnexpectedResult, updateResult.name()));
            }
            Ref result = this.repo.getRef(this.name);
            if (result == null) {
                throw new JGitInternalException(JGitText.get().createBranchFailedUnknownReason);
            }
            if (baseBranch.length() == 0) {
                Ref ref = result;
                return ref;
            }
            boolean doConfigure = this.upstreamMode == SetupUpstreamMode.SET_UPSTREAM || this.upstreamMode == SetupUpstreamMode.TRACK ? true : (this.upstreamMode == SetupUpstreamMode.NOTRACK ? false : ("false".equals(autosetupflag = this.repo.getConfig().getString("branch", null, "autosetupmerge")) ? false : ("always".equals(autosetupflag) ? true : baseBranch.startsWith("refs/remotes/"))));
            if (doConfigure) {
                StoredConfig config = this.repo.getConfig();
                String remoteName = this.repo.getRemoteName(baseBranch);
                if (remoteName != null) {
                    String branchName = this.repo.shortenRemoteBranchName(baseBranch);
                    config.setString("branch", this.name, "remote", remoteName);
                    String string3 = String.valueOf("refs/heads/");
                    String string4 = String.valueOf(branchName);
                    config.setString("branch", this.name, "merge", string4.length() != 0 ? string3.concat(string4) : new String(string3));
                } else {
                    config.setString("branch", this.name, "remote", ".");
                    config.setString("branch", this.name, "merge", baseBranch);
                }
                config.save();
            }
            Ref ref = result;
            return ref;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
        finally {
            revWalk.release();
        }
    }

    private ObjectId getStartPointObjectId() throws AmbiguousObjectException, RefNotFoundException, IOException {
        if (this.startCommit != null) {
            return this.startCommit.getId();
        }
        String startPointOrHead = this.getStartPointOrHead();
        ObjectId result = this.repo.resolve(startPointOrHead);
        if (result == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, startPointOrHead));
        }
        return result;
    }

    private String getStartPointOrHead() {
        return this.startPoint != null ? this.startPoint : "HEAD";
    }

    private void processOptions() throws InvalidRefNameException {
        block3: {
            block2: {
                if (this.name == null) break block2;
                String string = String.valueOf("refs/heads/");
                String string2 = String.valueOf(this.name);
                if (Repository.isValidRefName(string2.length() != 0 ? string.concat(string2) : new String(string))) break block3;
            }
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, this.name == null ? "<null>" : this.name));
        }
    }

    public CreateBranchCommand setName(String name) {
        this.checkCallable();
        this.name = name;
        return this;
    }

    public CreateBranchCommand setForce(boolean force) {
        this.checkCallable();
        this.force = force;
        return this;
    }

    public CreateBranchCommand setStartPoint(String startPoint) {
        this.checkCallable();
        this.startPoint = startPoint;
        this.startCommit = null;
        return this;
    }

    public CreateBranchCommand setStartPoint(RevCommit startPoint) {
        this.checkCallable();
        this.startCommit = startPoint;
        this.startPoint = null;
        return this;
    }

    public CreateBranchCommand setUpstreamMode(SetupUpstreamMode mode) {
        this.checkCallable();
        this.upstreamMode = mode;
        return this;
    }

    public static enum SetupUpstreamMode {
        TRACK,
        NOTRACK,
        SET_UPSTREAM;

    }
}

