/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.GitSmartHttpTools;
import org.eclipse.jgit.http.server.ServletUtils;
import org.eclipse.jgit.http.server.SmartOutputStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;

abstract class SmartServiceInfoRefs
implements Filter {
    private final String svc;
    private final Filter[] filters;

    SmartServiceInfoRefs(String service, List<Filter> filters) {
        this.svc = service;
        this.filters = filters.toArray(new Filter[filters.size()]);
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (this.svc.equals(req.getParameter("service"))) {
            Repository db = ServletUtils.getRepository(req);
            try {
                this.begin(req, db);
            }
            catch (ServiceNotAuthorizedException e) {
                res.sendError(401);
                return;
            }
            catch (ServiceNotEnabledException e) {
                GitSmartHttpTools.sendError(req, res, 403);
                return;
            }
            try {
                if (this.filters.length == 0) {
                    this.service(req, response);
                }
                new Chain().doFilter(request, response);
            }
            finally {
                req.removeAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private void service(ServletRequest request, ServletResponse response) throws IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        SmartOutputStream buf = new SmartOutputStream(req, res, true);
        try {
            res.setContentType(GitSmartHttpTools.infoRefsResultType(this.svc));
            PacketLineOut out = new PacketLineOut(buf);
            String string = String.valueOf(String.valueOf(this.svc));
            out.writeString(new StringBuilder(11 + string.length()).append("# service=").append(string).append("\n").toString());
            out.end();
            this.advertise(req, new RefAdvertiser.PacketLineOutRefAdvertiser(out));
            buf.close();
        }
        catch (ServiceNotAuthorizedException e) {
            res.sendError(401);
        }
        catch (ServiceNotEnabledException e) {
            GitSmartHttpTools.sendError(req, res, 403);
        }
        catch (ServiceMayNotContinueException e) {
            if (e.isOutput()) {
                buf.close();
            }
            GitSmartHttpTools.sendError(req, res, 403, e.getMessage());
        }
    }

    protected abstract void begin(HttpServletRequest var1, Repository var2) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException;

    protected abstract void advertise(HttpServletRequest var1, RefAdvertiser.PacketLineOutRefAdvertiser var2) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException;

    private class Chain
    implements FilterChain {
        private int filterIdx;

        private Chain() {
        }

        @Override
        public void doFilter(ServletRequest req, ServletResponse rsp) throws IOException, ServletException {
            if (this.filterIdx < SmartServiceInfoRefs.this.filters.length) {
                SmartServiceInfoRefs.this.filters[this.filterIdx++].doFilter(req, rsp, this);
            } else {
                SmartServiceInfoRefs.this.service(req, rsp);
            }
        }
    }
}

