/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server.glue;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.glue.ServletBinderImpl;
import org.eclipse.jgit.http.server.glue.UrlPipeline;
import org.eclipse.jgit.http.server.glue.WrappedRequest;

class SuffixPipeline
extends UrlPipeline {
    private final String suffix;
    private final int suffixLen;

    SuffixPipeline(String suffix, Filter[] filters, HttpServlet servlet) {
        super(filters, servlet);
        this.suffix = suffix;
        this.suffixLen = suffix.length();
    }

    @Override
    boolean match(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        return pathInfo != null && pathInfo.endsWith(this.suffix);
    }

    @Override
    void service(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        String curInfo = req.getPathInfo();
        String string = String.valueOf(req.getServletPath());
        String string2 = String.valueOf(curInfo);
        String newPath = string2.length() != 0 ? string.concat(string2) : new String(string);
        String newInfo = curInfo.substring(0, curInfo.length() - this.suffixLen);
        super.service(new WrappedRequest(req, newPath, newInfo), rsp);
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.suffix));
        return new StringBuilder(13 + string.length()).append("Pipeline[ *").append(string).append(" ]").toString();
    }

    static class Binder
    extends ServletBinderImpl {
        private final String suffix;

        Binder(String suffix) {
            this.suffix = suffix;
        }

        @Override
        UrlPipeline create() {
            return new SuffixPipeline(this.suffix, this.getFilters(), this.getServlet());
        }
    }
}

