/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsRefDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.util.io.CountingOutputStream;

public class DfsGarbageCollector {
    private final DfsRepository repo;
    private final DfsRefDatabase refdb;
    private final DfsObjDatabase objdb;
    private final List<DfsPackDescription> newPackDesc;
    private final List<PackWriter.Statistics> newPackStats;
    private final List<PackWriter.ObjectIdSet> newPackObj;
    private DfsReader ctx;
    private PackConfig packConfig;
    private long coalesceGarbageLimit = 0x3200000L;
    private Map<String, Ref> refsBefore;
    private List<DfsPackFile> packsBefore;
    private Set<ObjectId> allHeads;
    private Set<ObjectId> nonHeads;
    private Set<ObjectId> tagTargets;

    public DfsGarbageCollector(DfsRepository repository) {
        this.repo = repository;
        this.refdb = this.repo.getRefDatabase();
        this.objdb = this.repo.getObjectDatabase();
        this.newPackDesc = new ArrayList<DfsPackDescription>(4);
        this.newPackStats = new ArrayList<PackWriter.Statistics>(4);
        this.newPackObj = new ArrayList<PackWriter.ObjectIdSet>(4);
        this.packConfig = new PackConfig(this.repo);
        this.packConfig.setIndexVersion(2);
    }

    public PackConfig getPackConfig() {
        return this.packConfig;
    }

    public DfsGarbageCollector setPackConfig(PackConfig newConfig) {
        this.packConfig = newConfig;
        return this;
    }

    public long getCoalesceGarbageLimit() {
        return this.coalesceGarbageLimit;
    }

    public DfsGarbageCollector setCoalesceGarbageLimit(long limit) {
        this.coalesceGarbageLimit = limit;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pack(ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        if (this.packConfig.getIndexVersion() != 2) {
            throw new IllegalStateException("Only index version 2");
        }
        this.ctx = (DfsReader)this.objdb.newReader();
        try {
            this.refdb.clearCache();
            this.objdb.clearCache();
            this.refsBefore = this.refdb.getRefs("");
            this.packsBefore = this.packsToRebuild();
            if (this.packsBefore.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            this.allHeads = new HashSet<ObjectId>();
            this.nonHeads = new HashSet<ObjectId>();
            this.tagTargets = new HashSet<ObjectId>();
            for (Ref ref : this.refsBefore.values()) {
                if (ref.isSymbolic() || ref.getObjectId() == null) continue;
                if (DfsGarbageCollector.isHead(ref)) {
                    this.allHeads.add(ref.getObjectId());
                } else {
                    this.nonHeads.add(ref.getObjectId());
                }
                if (ref.getPeeledObjectId() == null) continue;
                this.tagTargets.add(ref.getPeeledObjectId());
            }
            this.tagTargets.addAll(this.allHeads);
            boolean rollback = true;
            try {
                this.packHeads(pm);
                this.packRest(pm);
                this.packGarbage(pm);
                this.objdb.commitPack(this.newPackDesc, this.toPrune());
                rollback = false;
                boolean bl = true;
                if (rollback) {
                    this.objdb.rollbackPack(this.newPackDesc);
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (rollback) {
                    this.objdb.rollbackPack(this.newPackDesc);
                }
                throw throwable;
            }
        }
        finally {
            this.ctx.release();
        }
    }

    private List<DfsPackFile> packsToRebuild() throws IOException {
        DfsPackFile[] packs = this.objdb.getPacks();
        ArrayList<DfsPackFile> out = new ArrayList<DfsPackFile>(packs.length);
        for (DfsPackFile p : packs) {
            DfsPackDescription d = p.getPackDescription();
            if (d.getPackSource() != DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE) {
                out.add(p);
                continue;
            }
            if (d.getFileSize(PackExt.PACK) >= this.coalesceGarbageLimit) continue;
            out.add(p);
        }
        return out;
    }

    public List<DfsPackDescription> getSourcePacks() {
        return this.toPrune();
    }

    public List<DfsPackDescription> getNewPacks() {
        return this.newPackDesc;
    }

    public List<PackWriter.Statistics> getNewPackStatistics() {
        return this.newPackStats;
    }

    private List<DfsPackDescription> toPrune() {
        int cnt = this.packsBefore.size();
        ArrayList<DfsPackDescription> all = new ArrayList<DfsPackDescription>(cnt);
        for (DfsPackFile pack : this.packsBefore) {
            all.add(pack.getPackDescription());
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packHeads(ProgressMonitor pm) throws IOException {
        if (this.allHeads.isEmpty()) {
            return;
        }
        PackWriter pw = this.newPackWriter();
        try {
            pw.setTagTargets(this.tagTargets);
            pw.preparePack(pm, this.allHeads, Collections.emptySet());
            if (0L < pw.getObjectCount()) {
                this.writePack(DfsObjDatabase.PackSource.GC, pw, pm);
            }
        }
        finally {
            pw.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packRest(ProgressMonitor pm) throws IOException {
        if (this.nonHeads.isEmpty()) {
            return;
        }
        PackWriter pw = this.newPackWriter();
        try {
            for (PackWriter.ObjectIdSet packedObjs : this.newPackObj) {
                pw.excludeObjects(packedObjs);
            }
            pw.preparePack(pm, this.nonHeads, this.allHeads);
            if (0L < pw.getObjectCount()) {
                this.writePack(DfsObjDatabase.PackSource.GC, pw, pm);
            }
        }
        finally {
            pw.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packGarbage(ProgressMonitor pm) throws IOException {
        PackConfig cfg = new PackConfig(this.packConfig);
        cfg.setReuseDeltas(true);
        cfg.setReuseObjects(true);
        cfg.setDeltaCompress(false);
        cfg.setBuildBitmaps(false);
        PackWriter pw = new PackWriter(cfg, (ObjectReader)this.ctx);
        pw.setDeltaBaseAsOffset(true);
        pw.setReuseDeltaCommits(true);
        try {
            RevWalk pool = new RevWalk(this.ctx);
            pm.beginTask("Finding garbage", this.objectsBefore());
            for (DfsPackFile oldPack : this.packsBefore) {
                PackIndex oldIdx = oldPack.getPackIndex(this.ctx);
                for (PackIndex.MutableEntry ent : oldIdx) {
                    pm.update(1);
                    ObjectId id = ent.toObjectId();
                    if (pool.lookupOrNull(id) != null || this.anyPackHas(id)) continue;
                    int type = oldPack.getObjectType(this.ctx, ent.getOffset());
                    pw.addObject(pool.lookupAny(id, type));
                }
            }
            pm.endTask();
            if (0L < pw.getObjectCount()) {
                this.writePack(DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE, pw, pm);
            }
        }
        finally {
            pw.release();
        }
    }

    private boolean anyPackHas(AnyObjectId id) {
        for (PackWriter.ObjectIdSet packedObjs : this.newPackObj) {
            if (!packedObjs.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static boolean isHead(Ref ref) {
        return ref.getName().startsWith("refs/heads/");
    }

    private int objectsBefore() {
        int cnt = 0;
        for (DfsPackFile p : this.packsBefore) {
            cnt = (int)((long)cnt + p.getPackDescription().getObjectCount());
        }
        return cnt;
    }

    private PackWriter newPackWriter() {
        PackWriter pw = new PackWriter(this.packConfig, (ObjectReader)this.ctx);
        pw.setDeltaBaseAsOffset(true);
        pw.setReuseDeltaCommits(false);
        return pw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DfsPackDescription writePack(DfsObjDatabase.PackSource source, PackWriter pw, ProgressMonitor pm) throws IOException {
        CountingOutputStream cnt;
        DfsPackDescription pack = this.repo.getObjectDatabase().newPack(source);
        this.newPackDesc.add(pack);
        try (DfsOutputStream out = this.objdb.writeFile(pack, PackExt.PACK);){
            pw.writePack(pm, pm, out);
            pack.addFileExt(PackExt.PACK);
        }
        out = this.objdb.writeFile(pack, PackExt.INDEX);
        try {
            cnt = new CountingOutputStream(out);
            pw.writeIndex(cnt);
            pack.addFileExt(PackExt.INDEX);
            pack.setFileSize(PackExt.INDEX, cnt.getCount());
            pack.setIndexVersion(pw.getIndexVersion());
        }
        finally {
            out.close();
        }
        if (pw.prepareBitmapIndex(pm)) {
            out = this.objdb.writeFile(pack, PackExt.BITMAP_INDEX);
            try {
                cnt = new CountingOutputStream(out);
                pw.writeBitmapIndex(cnt);
                pack.addFileExt(PackExt.BITMAP_INDEX);
                pack.setFileSize(PackExt.BITMAP_INDEX, cnt.getCount());
            }
            finally {
                out.close();
            }
        }
        final ObjectIdOwnerMap<ObjectIdOwnerMap.Entry> packedObjs = pw.getObjectSet();
        this.newPackObj.add(new PackWriter.ObjectIdSet(){

            @Override
            public boolean contains(AnyObjectId objectId) {
                return packedObjs.contains(objectId);
            }
        });
        PackWriter.Statistics stats = pw.getStatistics();
        pack.setPackStats(stats);
        this.newPackStats.add(stats);
        DfsBlockCache.getInstance().getOrCreate(pack, null);
        return pack;
    }
}

