/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import org.eclipse.jgit.errors.IllegalTodoFileModification;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;

public class RebaseTodoLine {
    Action action;
    final AbbreviatedObjectId commit;
    String shortMessage;
    String comment;

    public RebaseTodoLine(String newComment) {
        this.action = Action.COMMENT;
        this.setComment(newComment);
        this.commit = null;
        this.shortMessage = null;
    }

    public RebaseTodoLine(Action action, AbbreviatedObjectId commit, String shortMessage) {
        this.action = action;
        this.commit = commit;
        this.shortMessage = shortMessage;
        this.comment = null;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action newAction) throws IllegalTodoFileModification {
        if (!Action.COMMENT.equals((Object)this.action) && Action.COMMENT.equals((Object)newAction)) {
            if (this.comment == null) {
                String string = String.valueOf(String.valueOf(this.action.token));
                String string2 = String.valueOf(String.valueOf(this.commit == null ? "null" : this.commit.name()));
                String string3 = String.valueOf(String.valueOf(this.shortMessage == null ? "null" : this.shortMessage));
                this.comment = new StringBuilder(4 + string.length() + string2.length() + string3.length()).append("# ").append(string).append(" ").append(string2).append(" ").append(string3).toString();
            }
        } else if (Action.COMMENT.equals((Object)this.action) && !Action.COMMENT.equals((Object)newAction) && this.commit == null) {
            throw new IllegalTodoFileModification(MessageFormat.format(JGitText.get().cannotChangeActionOnComment, new Object[]{this.action, newAction}));
        }
        this.action = newAction;
    }

    public void setComment(String newComment) {
        if (newComment == null) {
            this.comment = null;
            return;
        }
        if (newComment.contains("\n") || newComment.contains("\r")) {
            throw RebaseTodoLine.createInvalidCommentException(newComment);
        }
        if (newComment.trim().length() == 0 || newComment.startsWith("#")) {
            this.comment = newComment;
            return;
        }
        throw RebaseTodoLine.createInvalidCommentException(newComment);
    }

    private static IllegalArgumentException createInvalidCommentException(String newComment) {
        return new IllegalArgumentException(MessageFormat.format(JGitText.get().argumentIsNotAValidCommentString, newComment));
    }

    public AbbreviatedObjectId getCommit() {
        return this.commit;
    }

    public String getShortMessage() {
        return this.shortMessage;
    }

    public void setShortMessage(String shortMessage) {
        this.shortMessage = shortMessage;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        String string = String.valueOf(String.valueOf((Object)this.action));
        String string2 = String.valueOf(String.valueOf(this.commit == null ? "null" : this.commit));
        String string3 = String.valueOf(String.valueOf(this.shortMessage == null ? "null" : this.shortMessage));
        String string4 = String.valueOf(String.valueOf(this.comment == null ? "" : this.comment));
        return new StringBuilder(12 + string.length() + string2.length() + string3.length() + string4.length()).append("Step[").append(string).append(", ").append(string2).append(", ").append(string3).append(", ").append(string4).append("]").toString();
    }

    public static enum Action {
        PICK("pick", "p"),
        REWORD("reword", "r"),
        EDIT("edit", "e"),
        SQUASH("squash", "s"),
        FIXUP("fixup", "f"),
        COMMENT("comment", "#");

        private final String token;
        private final String shortToken;

        private Action(String token, String shortToken) {
            this.token = token;
            this.shortToken = shortToken;
        }

        public String toToken() {
            return this.token;
        }

        public String toString() {
            String string = String.valueOf(String.valueOf(this.token));
            return new StringBuilder(8 + string.length()).append("Action[").append(string).append("]").toString();
        }

        public static Action parse(String token) {
            for (Action action : Action.values()) {
                if (!action.token.equals(token) && !action.shortToken.equals(token)) continue;
                return action;
            }
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().unknownOrUnsupportedCommand, new Object[]{token, Action.values()}));
        }
    }
}

