/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.merge.MergeChunk;
import org.eclipse.jgit.merge.MergeResult;

public class MergeFormatter {
    public void formatMerge(OutputStream out, MergeResult<RawText> res, List<String> seqName, String charsetName) throws IOException {
        String lastConflictingName = null;
        boolean threeWayMerge = res.getSequences().size() == 3;
        for (MergeChunk chunk : res) {
            String string;
            RawText seq = res.getSequences().get(chunk.getSequenceIndex());
            if (lastConflictingName != null && chunk.getConflictState() != MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE) {
                string = String.valueOf(String.valueOf(lastConflictingName));
                out.write(new StringBuilder(9 + string.length()).append(">>>>>>> ").append(string).append("\n").toString().getBytes(charsetName));
                lastConflictingName = null;
            }
            if (chunk.getConflictState() == MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE) {
                string = String.valueOf(String.valueOf(seqName.get(chunk.getSequenceIndex())));
                out.write(new StringBuilder(9 + string.length()).append("<<<<<<< ").append(string).append("\n").toString().getBytes(charsetName));
                lastConflictingName = seqName.get(chunk.getSequenceIndex());
            } else if (chunk.getConflictState() == MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE) {
                String string2;
                lastConflictingName = seqName.get(chunk.getSequenceIndex());
                if (threeWayMerge) {
                    string2 = "=======\n";
                } else {
                    string = String.valueOf(String.valueOf(lastConflictingName));
                    string2 = new StringBuilder(9 + string.length()).append("======= ").append(string).append("\n").toString();
                }
                out.write(string2.getBytes(charsetName));
            }
            for (int i = chunk.getBegin(); i < chunk.getEnd(); ++i) {
                seq.writeLine(out, i);
                out.write(10);
            }
        }
        if (lastConflictingName != null) {
            String string = String.valueOf(String.valueOf(lastConflictingName));
            out.write(new StringBuilder(9 + string.length()).append(">>>>>>> ").append(string).append("\n").toString().getBytes(charsetName));
        }
    }

    public void formatMerge(OutputStream out, MergeResult res, String baseName, String oursName, String theirsName, String charsetName) throws IOException {
        ArrayList<String> names = new ArrayList<String>(3);
        names.add(baseName);
        names.add(oursName);
        names.add(theirsName);
        this.formatMerge(out, res, names, charsetName);
    }
}

