/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.ChangeIdUtil;
import org.eclipse.jgit.util.StringUtils;

public class MergeMessageFormatter {
    public String format(List<Ref> refsToMerge, Ref target) {
        StringBuilder sb = new StringBuilder();
        sb.append("Merge ");
        ArrayList<String> branches = new ArrayList<String>();
        ArrayList<String> remoteBranches = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> commits = new ArrayList<String>();
        ArrayList<String> others = new ArrayList<String>();
        for (Ref ref : refsToMerge) {
            if (ref.getName().startsWith("refs/heads/")) {
                String string = String.valueOf(String.valueOf(Repository.shortenRefName(ref.getName())));
                branches.add(new StringBuilder(2 + string.length()).append("'").append(string).append("'").toString());
                continue;
            }
            if (ref.getName().startsWith("refs/remotes/")) {
                String string = String.valueOf(String.valueOf(Repository.shortenRefName(ref.getName())));
                remoteBranches.add(new StringBuilder(2 + string.length()).append("'").append(string).append("'").toString());
                continue;
            }
            if (ref.getName().startsWith("refs/tags/")) {
                String string = String.valueOf(String.valueOf(Repository.shortenRefName(ref.getName())));
                tags.add(new StringBuilder(2 + string.length()).append("'").append(string).append("'").toString());
                continue;
            }
            if (ref.getName().equals(ref.getObjectId().getName())) {
                String string = String.valueOf(String.valueOf(ref.getName()));
                commits.add(new StringBuilder(2 + string.length()).append("'").append(string).append("'").toString());
                continue;
            }
            others.add(ref.getName());
        }
        ArrayList<String> listings = new ArrayList<String>();
        if (!branches.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(branches, "branch", "branches"));
        }
        if (!remoteBranches.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(remoteBranches, "remote-tracking branch", "remote-tracking branches"));
        }
        if (!tags.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(tags, "tag", "tags"));
        }
        if (!commits.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(commits, "commit", "commits"));
        }
        if (!others.isEmpty()) {
            listings.add(StringUtils.join(others, ", ", " and "));
        }
        sb.append(StringUtils.join(listings, ", "));
        String targetName = target.getLeaf().getName();
        if (!targetName.equals("refs/heads/master")) {
            String targetShortName = Repository.shortenRefName(targetName);
            String string = String.valueOf(targetShortName);
            sb.append(string.length() != 0 ? " into ".concat(string) : new String(" into "));
        }
        return sb.toString();
    }

    public String formatWithConflicts(String message, List<String> conflictingPaths) {
        int i;
        StringBuilder sb = new StringBuilder();
        String[] lines = message.split("\n");
        int firstFooterLine = ChangeIdUtil.indexOfFirstFooterLine(lines);
        for (i = 0; i < firstFooterLine; ++i) {
            sb.append(lines[i]).append('\n');
        }
        if (firstFooterLine == lines.length && message.length() != 0) {
            sb.append('\n');
        }
        MergeMessageFormatter.addConflictsMessage(conflictingPaths, sb);
        if (firstFooterLine < lines.length) {
            sb.append('\n');
        }
        for (i = firstFooterLine; i < lines.length; ++i) {
            sb.append(lines[i]).append('\n');
        }
        return sb.toString();
    }

    private static void addConflictsMessage(List<String> conflictingPaths, StringBuilder sb) {
        sb.append("Conflicts:\n");
        for (String conflictingPath : conflictingPaths) {
            sb.append('\t').append(conflictingPath).append('\n');
        }
    }

    private static String joinNames(List<String> names, String singular, String plural) {
        if (names.size() == 1) {
            String string = String.valueOf(String.valueOf(singular));
            String string2 = String.valueOf(String.valueOf(names.get(0)));
            return new StringBuilder(1 + string.length() + string2.length()).append(string).append(" ").append(string2).toString();
        }
        String string = String.valueOf(String.valueOf(plural));
        String string3 = String.valueOf(String.valueOf(StringUtils.join(names, ", ", " and ")));
        return new StringBuilder(1 + string.length() + string3.length()).append(string).append(" ").append(string3).toString();
    }
}

