/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class PatternMatchRevFilter
extends RevFilter {
    private final String patternText;
    private final Matcher compiledPattern;

    protected static final String forceToRaw(String patternText) {
        byte[] b = Constants.encode(patternText);
        StringBuilder needle = new StringBuilder(b.length);
        for (int i = 0; i < b.length; ++i) {
            needle.append((char)(b[i] & 0xFF));
        }
        return needle.toString();
    }

    protected PatternMatchRevFilter(String pattern, boolean innerString, boolean rawEncoding, int flags) {
        if (pattern.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        this.patternText = pattern;
        if (innerString) {
            if (!pattern.startsWith("^") && !pattern.startsWith(".*")) {
                String string = String.valueOf(pattern);
                String string2 = pattern = string.length() != 0 ? ".*".concat(string) : new String(".*");
            }
            if (!pattern.endsWith("$") && !pattern.endsWith(".*")) {
                pattern = String.valueOf(pattern).concat(".*");
            }
        }
        String p = rawEncoding ? PatternMatchRevFilter.forceToRaw(pattern) : pattern;
        this.compiledPattern = Pattern.compile(p, flags).matcher("");
    }

    public String pattern() {
        return this.patternText;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.compiledPattern.reset(this.text(cmit)).matches();
    }

    @Override
    public boolean requiresCommitBody() {
        return true;
    }

    protected abstract CharSequence text(RevCommit var1);

    @Override
    public String toString() {
        String string = String.valueOf(String.valueOf(super.toString()));
        String string2 = String.valueOf(String.valueOf(this.patternText));
        return new StringBuilder(4 + string.length() + string2.length()).append(string).append("(\"").append(string2).append("\")").toString();
    }
}

