/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.MessageFormat;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.eclipse.jgit.internal.JGitText;

abstract class WalkEncryption {
    static final WalkEncryption NONE = new NoEncryption();
    static final String JETS3T_CRYPTO_VER = "jets3t-crypto-ver";
    static final String JETS3T_CRYPTO_ALG = "jets3t-crypto-alg";

    WalkEncryption() {
    }

    abstract OutputStream encrypt(OutputStream var1) throws IOException;

    abstract InputStream decrypt(InputStream var1) throws IOException;

    abstract void request(HttpURLConnection var1, String var2);

    abstract void validate(HttpURLConnection var1, String var2) throws IOException;

    protected void validateImpl(HttpURLConnection u, String p, String version, String name) throws IOException {
        String string = String.valueOf(p);
        String string2 = String.valueOf(JETS3T_CRYPTO_VER);
        String v = u.getHeaderField(string2.length() != 0 ? string.concat(string2) : new String(string));
        if (v == null) {
            v = "";
        }
        if (!version.equals(v)) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedEncryptionVersion, v));
        }
        String string3 = String.valueOf(p);
        String string4 = String.valueOf(JETS3T_CRYPTO_ALG);
        v = u.getHeaderField(string4.length() != 0 ? string3.concat(string4) : new String(string3));
        if (v == null) {
            v = "";
        }
        if (!name.equals(v)) {
            String string5 = String.valueOf(JGitText.get().unsupportedEncryptionAlgorithm);
            String string6 = String.valueOf(v);
            throw new IOException(string6.length() != 0 ? string5.concat(string6) : new String(string5));
        }
    }

    IOException error(Throwable why) {
        IOException e = new IOException(MessageFormat.format(JGitText.get().encryptionError, why.getMessage()));
        e.initCause(why);
        return e;
    }

    static class ObjectEncryptionV2
    extends WalkEncryption {
        private static int ITERATION_COUNT = 5000;
        private static byte[] salt = new byte[]{-92, 11, -56, 52, -42, -107, -13, 19};
        private final String algorithmName;
        private final SecretKey skey;
        private final PBEParameterSpec aspec;

        ObjectEncryptionV2(String algo, String key) throws InvalidKeySpecException, NoSuchAlgorithmException {
            this.algorithmName = algo;
            PBEKeySpec s = new PBEKeySpec(key.toCharArray(), salt, ITERATION_COUNT, 32);
            this.skey = SecretKeyFactory.getInstance(algo).generateSecret(s);
            this.aspec = new PBEParameterSpec(salt, ITERATION_COUNT);
        }

        @Override
        void request(HttpURLConnection u, String prefix) {
            String string = String.valueOf(prefix);
            String string2 = String.valueOf(WalkEncryption.JETS3T_CRYPTO_VER);
            u.setRequestProperty(string2.length() != 0 ? string.concat(string2) : new String(string), "2");
            String string3 = String.valueOf(prefix);
            String string4 = String.valueOf(WalkEncryption.JETS3T_CRYPTO_ALG);
            u.setRequestProperty(string4.length() != 0 ? string3.concat(string4) : new String(string3), this.algorithmName);
        }

        @Override
        void validate(HttpURLConnection u, String p) throws IOException {
            this.validateImpl(u, p, "2", this.algorithmName);
        }

        @Override
        OutputStream encrypt(OutputStream os) throws IOException {
            try {
                Cipher c = Cipher.getInstance(this.algorithmName);
                c.init(1, (Key)this.skey, this.aspec);
                return new CipherOutputStream(os, c);
            }
            catch (NoSuchAlgorithmException e) {
                throw this.error(e);
            }
            catch (NoSuchPaddingException e) {
                throw this.error(e);
            }
            catch (InvalidKeyException e) {
                throw this.error(e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw this.error(e);
            }
        }

        @Override
        InputStream decrypt(InputStream in) throws IOException {
            try {
                Cipher c = Cipher.getInstance(this.algorithmName);
                c.init(2, (Key)this.skey, this.aspec);
                return new CipherInputStream(in, c);
            }
            catch (NoSuchAlgorithmException e) {
                throw this.error(e);
            }
            catch (NoSuchPaddingException e) {
                throw this.error(e);
            }
            catch (InvalidKeyException e) {
                throw this.error(e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw this.error(e);
            }
        }
    }

    private static class NoEncryption
    extends WalkEncryption {
        private NoEncryption() {
        }

        @Override
        void request(HttpURLConnection u, String prefix) {
        }

        @Override
        void validate(HttpURLConnection u, String p) throws IOException {
            this.validateImpl(u, p, "", "");
        }

        @Override
        InputStream decrypt(InputStream in) {
            return in;
        }

        @Override
        OutputStream encrypt(OutputStream os) {
            return os;
        }
    }
}

