/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.http.HttpConnection;

public class HttpSupport {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String HDR_CACHE_CONTROL = "Cache-Control";
    public static final String HDR_PRAGMA = "Pragma";
    public static final String HDR_USER_AGENT = "User-Agent";
    public static final String HDR_DATE = "Date";
    public static final String HDR_EXPIRES = "Expires";
    public static final String HDR_ETAG = "ETag";
    public static final String HDR_IF_NONE_MATCH = "If-None-Match";
    public static final String HDR_LAST_MODIFIED = "Last-Modified";
    public static final String HDR_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HDR_ACCEPT = "Accept";
    public static final String HDR_CONTENT_TYPE = "Content-Type";
    public static final String HDR_CONTENT_LENGTH = "Content-Length";
    public static final String HDR_CONTENT_ENCODING = "Content-Encoding";
    public static final String HDR_CONTENT_RANGE = "Content-Range";
    public static final String HDR_ACCEPT_RANGES = "Accept-Ranges";
    public static final String HDR_IF_RANGE = "If-Range";
    public static final String HDR_RANGE = "Range";
    public static final String HDR_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ENCODING_GZIP = "gzip";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String HDR_AUTHORIZATION = "Authorization";
    public static final String HDR_WWW_AUTHENTICATE = "WWW-Authenticate";

    public static void encode(StringBuilder urlstr, String key) {
        if (key == null || key.length() == 0) {
            return;
        }
        try {
            urlstr.append(URLEncoder.encode(key, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(JGitText.get().couldNotURLEncodeToUTF8, e);
        }
    }

    public static int response(HttpConnection c) throws IOException {
        try {
            return c.getResponseCode();
        }
        catch (ConnectException ce) {
            String host = c.getURL().getHost();
            if ("Connection timed out: connect".equals(ce.getMessage())) {
                throw new ConnectException(MessageFormat.format(JGitText.get().connectionTimeOut, host));
            }
            String string = String.valueOf(String.valueOf(ce.getMessage()));
            String string2 = String.valueOf(String.valueOf(host));
            throw new ConnectException(new StringBuilder(1 + string.length() + string2.length()).append(string).append(" ").append(string2).toString());
        }
    }

    public static int response(HttpURLConnection c) throws IOException {
        try {
            return c.getResponseCode();
        }
        catch (ConnectException ce) {
            String host = c.getURL().getHost();
            if ("Connection timed out: connect".equals(ce.getMessage())) {
                throw new ConnectException(MessageFormat.format(JGitText.get().connectionTimeOut, host));
            }
            String string = String.valueOf(String.valueOf(ce.getMessage()));
            String string2 = String.valueOf(String.valueOf(host));
            throw new ConnectException(new StringBuilder(1 + string.length() + string2.length()).append(string).append(" ").append(string2).toString());
        }
    }

    public static Proxy proxyFor(ProxySelector proxySelector, URL u) throws ConnectException {
        try {
            return proxySelector.select(u.toURI()).get(0);
        }
        catch (URISyntaxException e) {
            ConnectException err = new ConnectException(MessageFormat.format(JGitText.get().cannotDetermineProxyFor, u));
            err.initCause(e);
            throw err;
        }
    }

    private HttpSupport() {
    }
}

