/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.registration.PrivateInternals_DynamicTypes;
import com.google.gerrit.extensions.webui.WebUiPlugin;
import com.google.gerrit.httpd.GerritConfigProvider;
import com.google.gerrit.httpd.GerritUiOptions;
import com.google.gerrit.httpd.GitOverHttpServlet;
import com.google.gerrit.httpd.GitWebConfig;
import com.google.gerrit.httpd.HttpRemotePeerProvider;
import com.google.gerrit.httpd.HttpRequestContext;
import com.google.gerrit.httpd.RequireSslFilter;
import com.google.gerrit.httpd.RunAsFilter;
import com.google.gerrit.httpd.UrlModule;
import com.google.gerrit.httpd.auth.become.BecomeAnyAccountModule;
import com.google.gerrit.httpd.auth.container.HttpAuthModule;
import com.google.gerrit.httpd.auth.container.HttpsClientSslCertModule;
import com.google.gerrit.httpd.auth.ldap.LdapAuthModule;
import com.google.gerrit.httpd.gitweb.GitWebModule;
import com.google.gerrit.httpd.rpc.UiRpcModule;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.server.RemotePeer;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.config.GerritRequestModule;
import com.google.gerrit.server.contact.ContactStore;
import com.google.gerrit.server.contact.ContactStoreProvider;
import com.google.gerrit.server.git.AsyncReceiveCommits;
import com.google.gerrit.server.util.GuiceRequestScopePropagator;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.servlet.RequestScoped;
import java.net.SocketAddress;

public class WebModule
extends LifecycleModule {
    private final AuthConfig authConfig;
    private final UrlModule.UrlConfig urlConfig;
    private final boolean wantSSL;
    private final GitWebConfig gitWebConfig;
    private final GerritUiOptions uiOptions;

    @Inject
    WebModule(AuthConfig authConfig, UrlModule.UrlConfig urlConfig, @CanonicalWebUrl @Nullable String canonicalUrl, GerritUiOptions uiOptions, Injector creatingInjector) {
        this.authConfig = authConfig;
        this.urlConfig = urlConfig;
        this.wantSSL = canonicalUrl != null && canonicalUrl.startsWith("https:");
        this.uiOptions = uiOptions;
        this.gitWebConfig = creatingInjector.createChildInjector(new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(GitWebConfig.class);
            }
        }).getInstance(GitWebConfig.class);
    }

    @Override
    protected void configure() {
        this.bind(RequestScopePropagator.class).to(GuiceRequestScopePropagator.class);
        this.bind(HttpRequestContext.class);
        if (this.wantSSL) {
            this.install(new RequireSslFilter.Module());
        }
        this.install(new RunAsFilter.Module());
        switch (this.authConfig.getAuthType()) {
            case HTTP: 
            case HTTP_LDAP: {
                this.install(new HttpAuthModule(this.authConfig));
                break;
            }
            case CLIENT_SSL_CERT_LDAP: {
                this.install(new HttpsClientSslCertModule());
                break;
            }
            case LDAP: 
            case LDAP_BIND: {
                this.install(new LdapAuthModule());
                break;
            }
            case DEVELOPMENT_BECOME_ANY_ACCOUNT: {
                this.install(new BecomeAnyAccountModule());
                break;
            }
            case OAUTH: 
            case OPENID: 
            case OPENID_SSO: 
            case CUSTOM_EXTENSION: {
                break;
            }
            default: {
                throw new ProvisionException("Unsupported loginType: " + (Object)((Object)this.authConfig.getAuthType()));
            }
        }
        this.install(new UrlModule(this.urlConfig, this.uiOptions, this.authConfig));
        this.install(new UiRpcModule());
        this.install(new GerritRequestModule());
        this.install(new GitOverHttpServlet.Module());
        this.bind(GitWebConfig.class).toInstance(this.gitWebConfig);
        if (this.gitWebConfig.getGitwebCGI() != null) {
            this.install(new GitWebModule());
        }
        this.bind(ContactStore.class).toProvider(ContactStoreProvider.class).in(Scopes.SINGLETON);
        this.bind(GerritConfigProvider.class);
        this.bind(GerritConfig.class).toProvider(GerritConfigProvider.class);
        DynamicSet.setOf(this.binder(), WebUiPlugin.class);
        this.install(new AsyncReceiveCommits.Module());
        this.bind(SocketAddress.class).annotatedWith(RemotePeer.class).toProvider(HttpRemotePeerProvider.class).in(RequestScoped.class);
        this.listener().toInstance(PrivateInternals_DynamicTypes.registerInParentInjectors());
    }
}

