/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.rules;

import com.google.gerrit.rules.StoredValue;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.project.ProjectCache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.Assisted;
import com.googlecode.prolog_cafe.lang.BufferingPrologControl;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.PrologMachineCopy;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrologEnvironment
extends BufferingPrologControl {
    private static final Logger log = LoggerFactory.getLogger(PrologEnvironment.class);
    static final int MAX_ARITY = 8;
    private final Args args;
    private final Map<StoredValue<Object>, Object> storedValues;
    private List<Runnable> cleanup;

    @Inject
    PrologEnvironment(Args a, @Assisted PrologMachineCopy src) {
        super(src);
        this.setMaxArity(8);
        this.setEnabled(EnumSet.allOf(Prolog.Feature.class), false);
        this.args = a;
        this.storedValues = new HashMap<StoredValue<Object>, Object>();
        this.cleanup = new LinkedList<Runnable>();
    }

    public Args getArgs() {
        return this.args;
    }

    public <T> T get(StoredValue<T> sv) {
        return (T)this.storedValues.get(sv);
    }

    public <T> void set(StoredValue<T> sv, T obj) {
        this.storedValues.put(sv, obj);
    }

    public void copyStoredValues(PrologEnvironment child) {
        this.storedValues.putAll(child.storedValues);
        this.setCleanup(child.cleanup);
    }

    public void setCleanup(List<Runnable> newCleanupList) {
        newCleanupList.addAll(this.cleanup);
        this.cleanup = newCleanupList;
    }

    public void addToCleanup(Runnable task) {
        this.cleanup.add(task);
    }

    public void close() {
        Iterator<Runnable> i = this.cleanup.iterator();
        while (i.hasNext()) {
            try {
                i.next().run();
            }
            catch (Throwable err) {
                log.error("Failed to execute cleanup for PrologEnvironment", err);
            }
            i.remove();
        }
    }

    @Singleton
    public static class Args {
        private final ProjectCache projectCache;
        private final GitRepositoryManager repositoryManager;
        private final PatchListCache patchListCache;
        private final PatchSetInfoFactory patchSetInfoFactory;
        private final IdentifiedUser.GenericFactory userFactory;
        private final Provider<AnonymousUser> anonymousUser;

        @Inject
        Args(ProjectCache projectCache, GitRepositoryManager repositoryManager, PatchListCache patchListCache, PatchSetInfoFactory patchSetInfoFactory, IdentifiedUser.GenericFactory userFactory, Provider<AnonymousUser> anonymousUser) {
            this.projectCache = projectCache;
            this.repositoryManager = repositoryManager;
            this.patchListCache = patchListCache;
            this.patchSetInfoFactory = patchSetInfoFactory;
            this.userFactory = userFactory;
            this.anonymousUser = anonymousUser;
        }

        public ProjectCache getProjectCache() {
            return this.projectCache;
        }

        public GitRepositoryManager getGitRepositoryManager() {
            return this.repositoryManager;
        }

        public PatchListCache getPatchListCache() {
            return this.patchListCache;
        }

        public PatchSetInfoFactory getPatchSetInfoFactory() {
            return this.patchSetInfoFactory;
        }

        public IdentifiedUser.GenericFactory getUserFactory() {
            return this.userFactory;
        }

        public AnonymousUser getAnonymousUser() {
            return this.anonymousUser.get();
        }
    }

    public static interface Factory {
        public PrologEnvironment create(PrologMachineCopy var1);
    }
}

