/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupDetail;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountInfoCacheFactory;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.account.GroupInfoCacheFactory;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;

public class GroupDetailFactory
implements Callable<GroupDetail> {
    private final ReviewDb db;
    private final GroupControl.Factory groupControl;
    private final GroupCache groupCache;
    private final GroupBackend groupBackend;
    private final AccountInfoCacheFactory aic;
    private final GroupInfoCacheFactory gic;
    private final AccountGroup.Id groupId;
    private GroupControl control;

    @Inject
    GroupDetailFactory(ReviewDb db, GroupControl.Factory groupControl, GroupCache groupCache, GroupBackend groupBackend, AccountInfoCacheFactory.Factory accountInfoCacheFactory, GroupInfoCacheFactory.Factory groupInfoCacheFactory, @Assisted AccountGroup.Id groupId) {
        this.db = db;
        this.groupControl = groupControl;
        this.groupCache = groupCache;
        this.groupBackend = groupBackend;
        this.aic = accountInfoCacheFactory.create();
        this.gic = groupInfoCacheFactory.create();
        this.groupId = groupId;
    }

    @Override
    public GroupDetail call() throws OrmException, NoSuchGroupException {
        this.control = this.groupControl.validateFor(this.groupId);
        AccountGroup group = this.groupCache.get(this.groupId);
        GroupDetail detail = new GroupDetail();
        detail.setGroup(group);
        GroupDescription.Basic ownerGroup = this.groupBackend.get(group.getOwnerGroupUUID());
        if (ownerGroup != null) {
            detail.setOwnerGroup(GroupReference.forGroup(ownerGroup));
        }
        detail.setMembers(this.loadMembers());
        detail.setIncludes(this.loadIncludes());
        detail.setAccounts(this.aic.create());
        detail.setCanModify(this.control.isOwner());
        return detail;
    }

    private List<AccountGroupMember> loadMembers() throws OrmException {
        ArrayList<AccountGroupMember> members = new ArrayList<AccountGroupMember>();
        for (AccountGroupMember m : this.db.accountGroupMembers().byGroup(this.groupId)) {
            if (!this.control.canSeeMember(m.getAccountId())) continue;
            this.aic.want(m.getAccountId());
            members.add(m);
        }
        Collections.sort(members, new Comparator<AccountGroupMember>(){

            @Override
            public int compare(AccountGroupMember o1, AccountGroupMember o2) {
                Account a = GroupDetailFactory.this.aic.get(o1.getAccountId());
                Account b = GroupDetailFactory.this.aic.get(o2.getAccountId());
                return this.n(a).compareTo(this.n(b));
            }

            private String n(Account a) {
                String n = a.getFullName();
                if (n != null && n.length() > 0) {
                    return n;
                }
                n = a.getPreferredEmail();
                if (n != null && n.length() > 0) {
                    return n;
                }
                return a.getId().toString();
            }
        });
        return members;
    }

    private List<AccountGroupById> loadIncludes() throws OrmException {
        ArrayList<AccountGroupById> groups = new ArrayList<AccountGroupById>();
        for (AccountGroupById m : this.db.accountGroupById().byGroup(this.groupId)) {
            if (!this.control.canSeeGroup(m.getIncludeUUID())) continue;
            this.gic.want(m.getIncludeUUID());
            groups.add(m);
        }
        Collections.sort(groups, new Comparator<AccountGroupById>(){

            @Override
            public int compare(AccountGroupById o1, AccountGroupById o2) {
                GroupDescription.Basic a = GroupDetailFactory.this.gic.get(o1.getIncludeUUID());
                GroupDescription.Basic b = GroupDetailFactory.this.gic.get(o2.getIncludeUUID());
                return this.n(a).compareTo(this.n(b));
            }

            private String n(GroupDescription.Basic a) {
                if (a == null) {
                    return "";
                }
                String n = a.getName();
                if (n != null && n.length() > 0) {
                    return n;
                }
                return a.getGroupUUID().get();
            }
        });
        return groups;
    }

    public static interface Factory {
        public GroupDetailFactory create(AccountGroup.Id var1);
    }
}

