/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.Sets;
import com.google.gerrit.extensions.common.SubmitType;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Submit;
import com.google.gerrit.server.change.TestSubmitType;
import com.google.gerrit.server.git.BranchOrderSection;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeException;
import com.google.gerrit.server.git.strategy.SubmitStrategyFactory;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mergeable
implements RestReadView<RevisionResource> {
    private static final Logger log = LoggerFactory.getLogger(Mergeable.class);
    @Option(name="--other-branches", aliases={"-o"}, usage="test mergeability for other branches too")
    private boolean otherBranches;
    private final TestSubmitType.Get submitType;
    private final GitRepositoryManager gitManager;
    private final ProjectCache projectCache;
    private final SubmitStrategyFactory submitStrategyFactory;
    private final Provider<ReviewDb> db;
    private final ChangeIndexer indexer;
    private boolean force;

    @Option(name="--force", aliases={"-f"}, usage="force recheck of mergeable field")
    public void setForce(boolean force) {
        this.force = force;
    }

    @Inject
    Mergeable(TestSubmitType.Get submitType, GitRepositoryManager gitManager, ProjectCache projectCache, SubmitStrategyFactory submitStrategyFactory, Provider<ReviewDb> db, ChangeIndexer indexer) {
        this.submitType = submitType;
        this.gitManager = gitManager;
        this.projectCache = projectCache;
        this.submitStrategyFactory = submitStrategyFactory;
        this.db = db;
        this.indexer = indexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeableInfo apply(RevisionResource resource) throws AuthException, ResourceConflictException, BadRequestException, OrmException, IOException {
        Change change = resource.getChange();
        PatchSet ps = resource.getPatchSet();
        MergeableInfo result = new MergeableInfo();
        if (!change.getStatus().isOpen()) {
            throw new ResourceConflictException("change is " + Submit.status(change));
        }
        if (!ps.getId().equals(change.currentPatchSetId())) {
            return result;
        }
        result.submitType = this.submitType.apply(resource);
        result.mergeable = change.isMergeable();
        try (Repository git = this.gitManager.openRepository(change.getProject());){
            Map<String, Ref> refs = git.getRefDatabase().getRefs("");
            Ref ref = refs.get(change.getDest().get());
            if (this.force || Mergeable.isStale(change, ref)) {
                result.mergeable = this.refresh(change, ps, result.submitType, git, refs, ref);
            }
            if (this.otherBranches) {
                result.mergeableInto = new ArrayList<String>();
                BranchOrderSection branchOrder = this.projectCache.get(change.getProject()).getBranchOrderSection();
                if (branchOrder != null) {
                    int prefixLen = "refs/heads/".length();
                    for (String n : branchOrder.getMoreStable(ref.getName())) {
                        Ref other = refs.get(n);
                        if (other == null || !this.isMergeable(change, ps, SubmitType.CHERRY_PICK, git, refs, other)) continue;
                        result.mergeableInto.add(other.getName().substring(prefixLen));
                    }
                }
            }
        }
        return result;
    }

    private static boolean isStale(Change change, Ref ref) {
        return change.getLastSha1MergeTested() == null || !Mergeable.toRevId(ref).equals(change.getLastSha1MergeTested());
    }

    private static RevId toRevId(Ref ref) {
        return new RevId(ref != null && ref.getObjectId() != null ? ref.getObjectId().name() : "");
    }

    private boolean refresh(Change change, final PatchSet ps, SubmitType type, Repository git, Map<String, Ref> refs, final Ref ref) throws IOException, OrmException {
        final boolean mergeable = this.isMergeable(change, ps, type, git, refs, ref);
        Change c = this.db.get().changes().atomicUpdate(change.getId(), new AtomicUpdate<Change>(){

            @Override
            public Change update(Change c) {
                if (c.getStatus().isOpen() && ps.getId().equals(c.currentPatchSetId())) {
                    c.setMergeable(mergeable);
                    c.setLastSha1MergeTested(Mergeable.toRevId(ref));
                    return c;
                }
                return null;
            }
        });
        if (c != null) {
            this.indexer.index(this.db.get(), c);
        }
        return mergeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMergeable(Change change, PatchSet ps, SubmitType type, Repository git, Map<String, Ref> refs, Ref ref) throws IOException, OrmException {
        RevWalk rw = new RevWalk(git){

            @Override
            protected CodeReviewCommit createCommit(AnyObjectId id) {
                return new CodeReviewCommit(id);
            }
        };
        try {
            boolean mergeable;
            ObjectId id;
            try {
                id = ObjectId.fromString(ps.getRevision().get());
            }
            catch (IllegalArgumentException e) {
                log.error(String.format("Invalid revision on patch set %d of %d", ps.getId().get(), change.getId().get()));
                boolean bl = false;
                rw.release();
                return bl;
            }
            RevFlag canMerge = rw.newFlag("CAN_MERGE");
            CodeReviewCommit rev = Mergeable.parse(rw, id);
            rev.add(canMerge);
            if (ref == null || ref.getObjectId() == null) {
                mergeable = true;
            } else {
                CodeReviewCommit tip = Mergeable.parse(rw, ref.getObjectId());
                Set<RevCommit> accepted = Mergeable.alreadyAccepted(rw, refs.values());
                accepted.add(tip);
                accepted.addAll(Arrays.asList(rev.getParents()));
                mergeable = this.submitStrategyFactory.create(type, this.db.get(), git, rw, null, canMerge, accepted, change.getDest()).dryRun(tip, rev);
            }
            boolean bl = mergeable;
            return bl;
        }
        catch (MergeException | NoSuchProjectException | IOException e) {
            log.error(String.format("Cannot merge test change %d", change.getId().get()), e);
            boolean bl = false;
            return bl;
        }
        finally {
            rw.release();
        }
    }

    private static Set<RevCommit> alreadyAccepted(RevWalk rw, Collection<Ref> refs) throws MissingObjectException, IOException {
        HashSet<RevCommit> accepted = Sets.newHashSet();
        for (Ref r : refs) {
            if (!r.getName().startsWith("refs/heads/") && !r.getName().startsWith("refs/tags/")) continue;
            try {
                accepted.add(rw.parseCommit(r.getObjectId()));
            }
            catch (IncorrectObjectTypeException nonCommit) {}
        }
        return accepted;
    }

    private static CodeReviewCommit parse(RevWalk rw, ObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return (CodeReviewCommit)rw.parseCommit(id);
    }

    public static class MergeableInfo {
        public SubmitType submitType;
        public boolean mergeable;
        public List<String> mergeableInto;
    }
}

