/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredMimeTypes {
    private static final Logger log = LoggerFactory.getLogger(ConfiguredMimeTypes.class);
    private static final String MIMETYPE = "mimetype";
    private static final String KEY_PATH = "path";
    private final List<TypeMatcher> matchers;

    ConfiguredMimeTypes(String projectName, Config rc) {
        Set<String> types = rc.getSubsections(MIMETYPE);
        if (types.isEmpty()) {
            this.matchers = Collections.emptyList();
        } else {
            this.matchers = new ArrayList<TypeMatcher>();
            for (String typeName : types) {
                for (String path : rc.getStringList(MIMETYPE, typeName, KEY_PATH)) {
                    try {
                        this.add(typeName, path);
                    }
                    catch (PatternSyntaxException | InvalidPatternException e) {
                        log.warn(String.format("Ignoring invalid %s.%s.%s = %s in project %s: %s", MIMETYPE, typeName, KEY_PATH, path, projectName, e.getMessage()));
                    }
                }
            }
        }
    }

    private void add(String typeName, String path) throws PatternSyntaxException, InvalidPatternException {
        if (path.startsWith("^")) {
            this.matchers.add(new ReType(typeName, path));
        } else {
            this.matchers.add(new FnType(typeName, path));
        }
    }

    public String getMimeType(String path) {
        for (TypeMatcher m : this.matchers) {
            if (!m.matches(path)) continue;
            return m.type;
        }
        return null;
    }

    private static class ReType
    extends TypeMatcher {
        private final Pattern re;

        ReType(String type, String pattern) throws PatternSyntaxException {
            super(type);
            this.re = Pattern.compile(pattern);
        }

        @Override
        boolean matches(String input) {
            return this.re.matcher(input).matches();
        }
    }

    private static class FnType
    extends TypeMatcher {
        private final FileNameMatcher matcher;

        FnType(String type, String pattern) throws InvalidPatternException {
            super(type);
            this.matcher = new FileNameMatcher(pattern, null);
        }

        @Override
        boolean matches(String input) {
            FileNameMatcher m = new FileNameMatcher(this.matcher);
            m.append(input);
            return m.isMatch();
        }
    }

    private static abstract class TypeMatcher {
        final String type;

        TypeMatcher(String type) {
            this.type = type;
        }

        abstract boolean matches(String var1);
    }
}

