/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.base.Preconditions;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.VersionedMetaData;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.project.ChangeControl;
import java.io.IOException;
import java.util.Date;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public abstract class AbstractChangeUpdate
extends VersionedMetaData {
    protected final NotesMigration migration;
    protected final GitRepositoryManager repoManager;
    protected final MetaDataUpdate.User updateFactory;
    protected final ChangeControl ctl;
    protected final PersonIdent serverIdent;
    protected final Date when;
    protected PatchSet.Id psId;

    AbstractChangeUpdate(NotesMigration migration, GitRepositoryManager repoManager, MetaDataUpdate.User updateFactory, ChangeControl ctl, PersonIdent serverIdent, Date when) {
        this.migration = migration;
        this.repoManager = repoManager;
        this.updateFactory = updateFactory;
        this.ctl = ctl;
        this.serverIdent = serverIdent;
        this.when = when;
    }

    public Change getChange() {
        return this.ctl.getChange();
    }

    public Date getWhen() {
        return this.when;
    }

    public IdentifiedUser getUser() {
        return (IdentifiedUser)this.ctl.getCurrentUser();
    }

    public void setPatchSetId(PatchSet.Id psId) {
        Preconditions.checkArgument(psId == null || psId.getParentKey().equals(this.getChange().getId()));
        this.psId = psId;
    }

    private void load() throws IOException {
        if (this.migration.write() && this.getRevision() == null) {
            try (Repository repo = this.repoManager.openRepository(this.getProjectName());){
                this.load(repo);
            }
        }
    }

    @Override
    public VersionedMetaData.BatchMetaDataUpdate openUpdate(MetaDataUpdate update) throws IOException {
        throw new UnsupportedOperationException("use openUpdate()");
    }

    public VersionedMetaData.BatchMetaDataUpdate openUpdate() throws IOException {
        if (this.migration.write()) {
            this.load();
            MetaDataUpdate md = this.updateFactory.create(this.getProjectName(), this.getUser());
            md.setAllowEmpty(true);
            return super.openUpdate(md);
        }
        return new VersionedMetaData.BatchMetaDataUpdate(){

            @Override
            public void write(CommitBuilder commit) {
            }

            @Override
            public void write(VersionedMetaData config, CommitBuilder commit) {
            }

            @Override
            public RevCommit createRef(String refName) {
                return null;
            }

            @Override
            public RevCommit commit() {
                return null;
            }

            @Override
            public RevCommit commitAt(ObjectId revision) {
                return null;
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public RevCommit commit(MetaDataUpdate md) throws IOException {
        throw new UnsupportedOperationException("use commit()");
    }

    @Override
    protected void onLoad() throws IOException, ConfigInvalidException {
    }

    protected PersonIdent newIdent(Account author, Date when) {
        return new PersonIdent(author.getFullName(), author.getId().get() + "@" + "gerrit", when, this.serverIdent.getTimeZone());
    }

    protected abstract Project.NameKey getProjectName();
}

