/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.VersionedMetaData;
import com.google.gerrit.server.notedb.AbstractChangeUpdate;
import com.google.gerrit.server.notedb.ChangeNoteUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.CommentsInNotesUtil;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.ReviewerState;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.util.LabelVote;
import com.google.gwtorm.server.OrmException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.FooterKey;
import org.eclipse.jgit.revwalk.RevCommit;

public class ChangeUpdate
extends AbstractChangeUpdate {
    private final AccountCache accountCache;
    private final Map<String, Optional<Short>> approvals;
    private final Map<Account.Id, ReviewerState> reviewers;
    private Change.Status status;
    private String subject;
    private List<SubmitRecord> submitRecords;
    private final CommentsInNotesUtil commentsUtil;
    private List<PatchLineComment> commentsForBase;
    private List<PatchLineComment> commentsForPs;
    private String changeMessage;

    @AssistedInject
    private ChangeUpdate(@GerritPersonIdent PersonIdent serverIdent, GitRepositoryManager repoManager, NotesMigration migration, AccountCache accountCache, MetaDataUpdate.User updateFactory, ProjectCache projectCache, IdentifiedUser user, @Assisted ChangeControl ctl, CommentsInNotesUtil commentsUtil) {
        this(serverIdent, repoManager, migration, accountCache, updateFactory, projectCache, ctl, serverIdent.getWhen(), commentsUtil);
    }

    @AssistedInject
    private ChangeUpdate(@GerritPersonIdent PersonIdent serverIdent, GitRepositoryManager repoManager, NotesMigration migration, AccountCache accountCache, MetaDataUpdate.User updateFactory, ProjectCache projectCache, @Assisted ChangeControl ctl, @Assisted Date when, CommentsInNotesUtil commentsUtil) {
        this(serverIdent, repoManager, migration, accountCache, updateFactory, ctl, when, projectCache.get(ChangeUpdate.getProjectName(ctl)).getLabelTypes().nameComparator(), commentsUtil);
    }

    private static Project.NameKey getProjectName(ChangeControl ctl) {
        return ctl.getChange().getDest().getParentKey();
    }

    @AssistedInject
    private ChangeUpdate(@GerritPersonIdent PersonIdent serverIdent, GitRepositoryManager repoManager, NotesMigration migration, AccountCache accountCache, MetaDataUpdate.User updateFactory, @Assisted ChangeControl ctl, @Assisted Date when, @Assisted Comparator<String> labelNameComparator, CommentsInNotesUtil commentsUtil) {
        super(migration, repoManager, updateFactory, ctl, serverIdent, when);
        this.accountCache = accountCache;
        this.commentsUtil = commentsUtil;
        this.approvals = Maps.newTreeMap(labelNameComparator);
        this.reviewers = Maps.newLinkedHashMap();
        this.commentsForPs = Lists.newArrayList();
        this.commentsForBase = Lists.newArrayList();
    }

    public void setStatus(Change.Status status) {
        Preconditions.checkArgument(status != Change.Status.SUBMITTED, "use submit(Iterable<PatchSetApproval>)");
        this.status = status;
    }

    public void putApproval(String label, short value) {
        this.approvals.put(label, Optional.of(value));
    }

    public void removeApproval(String label) {
        this.approvals.put(label, Optional.absent());
    }

    public void submit(Iterable<SubmitRecord> submitRecords) {
        this.status = Change.Status.SUBMITTED;
        this.submitRecords = ImmutableList.copyOf(submitRecords);
        Preconditions.checkArgument(!this.submitRecords.isEmpty(), "no submit records specified at submit time");
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setChangeMessage(String changeMessage) {
        this.changeMessage = changeMessage;
    }

    public void putComment(PatchLineComment comment) {
        Preconditions.checkArgument(this.psId != null, "setPatchSetId must be called before putComment");
        Preconditions.checkArgument(CommentsInNotesUtil.getCommentPsId(comment).equals(this.psId), "Comment on %s doesn't match previous patch set %s", CommentsInNotesUtil.getCommentPsId(comment), this.psId);
        Preconditions.checkArgument(comment.getRevId() != null);
        if (comment.getSide() == 0) {
            this.commentsForBase.add(comment);
        } else {
            this.commentsForPs.add(comment);
        }
    }

    public void putReviewer(Account.Id reviewer, ReviewerState type) {
        Preconditions.checkArgument(type != ReviewerState.REMOVED, "invalid ReviewerType");
        this.reviewers.put(reviewer, type);
    }

    public void removeReviewer(Account.Id reviewer) {
        this.reviewers.put(reviewer, ReviewerState.REMOVED);
    }

    private ObjectId storeCommentsInNotes() throws OrmException, IOException {
        ChangeNotes notes = (ChangeNotes)this.ctl.getNotes().load();
        NoteMap noteMap = notes.getNoteMap();
        if (noteMap == null) {
            noteMap = NoteMap.newEmptyMap();
        }
        if (this.commentsForPs.isEmpty() && this.commentsForBase.isEmpty()) {
            return null;
        }
        ImmutableListMultimap<PatchSet.Id, PatchLineComment> allCommentsOnBases = notes.getBaseComments();
        ImmutableListMultimap<PatchSet.Id, PatchLineComment> allCommentsOnPs = notes.getPatchSetComments();
        if (!this.commentsForBase.isEmpty()) {
            ArrayList<PatchLineComment> baseCommentsForThisPs = new ArrayList<PatchLineComment>(allCommentsOnBases.get(this.psId));
            baseCommentsForThisPs.addAll(this.commentsForBase);
            this.commentsUtil.writeCommentsToNoteMap(noteMap, baseCommentsForThisPs, this.inserter);
        }
        if (!this.commentsForPs.isEmpty()) {
            ArrayList<PatchLineComment> commentsForThisPs = new ArrayList<PatchLineComment>(allCommentsOnPs.get(this.psId));
            commentsForThisPs.addAll(this.commentsForPs);
            this.commentsUtil.writeCommentsToNoteMap(noteMap, commentsForThisPs, this.inserter);
        }
        return noteMap.writeTree(this.inserter);
    }

    public RevCommit commit() throws IOException {
        try (VersionedMetaData.BatchMetaDataUpdate batch = this.openUpdate();){
            RevCommit c;
            ObjectId treeId;
            CommitBuilder builder = new CommitBuilder();
            if (this.migration.write() && (treeId = this.storeCommentsInNotes()) != null) {
                builder.setTreeId(treeId);
            }
            batch.write(builder);
            RevCommit revCommit = c = batch.commit();
            return revCommit;
        }
    }

    @Override
    protected String getRefName() {
        return ChangeNoteUtil.changeRefName(this.getChange().getId());
    }

    @Override
    protected boolean onSave(CommitBuilder commit) {
        if (this.isEmpty()) {
            return false;
        }
        commit.setAuthor(this.newIdent(this.getUser().getAccount(), this.when));
        commit.setCommitter(new PersonIdent(this.serverIdent, this.when));
        int ps = this.psId != null ? this.psId.get() : this.getChange().currentPatchSetId().get();
        StringBuilder msg = new StringBuilder();
        if (this.subject != null) {
            msg.append(this.subject);
        } else {
            msg.append("Update patch set ").append(ps);
        }
        msg.append("\n\n");
        if (this.changeMessage != null) {
            msg.append(this.changeMessage);
            msg.append("\n\n");
        }
        ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_PATCH_SET, ps);
        if (this.status != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_STATUS, this.status.name().toLowerCase());
        }
        for (Map.Entry<Account.Id, ReviewerState> entry : this.reviewers.entrySet()) {
            Account account = this.accountCache.get(entry.getKey()).getAccount();
            PersonIdent ident = this.newIdent(account, this.when);
            ChangeUpdate.addFooter(msg, entry.getValue().getFooterKey()).append(ident.getName()).append(" <").append(ident.getEmailAddress()).append(">\n");
        }
        for (Map.Entry<Object, Object> entry : this.approvals.entrySet()) {
            if (!((Optional)entry.getValue()).isPresent()) {
                ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_LABEL, Character.valueOf('-'), entry.getKey());
                continue;
            }
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_LABEL, new LabelVote((String)entry.getKey(), (Short)((Optional)entry.getValue()).get()).formatWithEquals());
        }
        if (this.submitRecords != null) {
            for (SubmitRecord submitRecord : this.submitRecords) {
                ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_SUBMITTED_WITH).append((Object)submitRecord.status);
                if (submitRecord.errorMessage != null) {
                    msg.append(' ').append(ChangeUpdate.sanitizeFooter(submitRecord.errorMessage));
                }
                msg.append('\n');
                if (submitRecord.labels == null) continue;
                for (SubmitRecord.Label label : submitRecord.labels) {
                    ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_SUBMITTED_WITH).append((Object)label.status).append(": ").append(label.label);
                    if (label.appliedBy != null) {
                        PersonIdent ident = this.newIdent(this.accountCache.get(label.appliedBy).getAccount(), this.when);
                        msg.append(": ").append(ident.getName()).append(" <").append(ident.getEmailAddress()).append('>');
                    }
                    msg.append('\n');
                }
            }
        }
        commit.setMessage(msg.toString());
        return true;
    }

    @Override
    protected Project.NameKey getProjectName() {
        return ChangeUpdate.getProjectName(this.ctl);
    }

    private boolean isEmpty() {
        return this.approvals.isEmpty() && this.reviewers.isEmpty() && this.commentsForBase.isEmpty() && this.commentsForPs.isEmpty() && this.status == null && this.submitRecords == null && this.changeMessage == null;
    }

    private static StringBuilder addFooter(StringBuilder sb, FooterKey footer) {
        return sb.append(footer.getName()).append(": ");
    }

    private static void addFooter(StringBuilder sb, FooterKey footer, Object ... values) {
        ChangeUpdate.addFooter(sb, footer);
        for (Object value : values) {
            sb.append(value);
        }
        sb.append('\n');
    }

    private static String sanitizeFooter(String value) {
        return value.replace('\n', ' ').replace('\u0000', ' ');
    }

    public static interface Factory {
        public ChangeUpdate create(ChangeControl var1);

        public ChangeUpdate create(ChangeControl var1, Date var2);

        @VisibleForTesting
        public ChangeUpdate create(ChangeControl var1, Date var2, Comparator<String> var3);
    }
}

