/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.common.cache.LoadingCache;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.patch.IntraLineDiff;
import com.google.gerrit.server.patch.IntraLineDiffKey;
import com.google.gerrit.server.patch.IntraLineLoader;
import com.google.gerrit.server.patch.IntraLineWeigher;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListKey;
import com.google.gerrit.server.patch.PatchListLoader;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.PatchListWeigher;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.concurrent.ExecutionException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;

@Singleton
public class PatchListCacheImpl
implements PatchListCache {
    static final String FILE_NAME = "diff";
    static final String INTRA_NAME = "diff_intraline";
    private final LoadingCache<PatchListKey, PatchList> fileCache;
    private final LoadingCache<IntraLineDiffKey, IntraLineDiff> intraCache;
    private final boolean computeIntraline;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.persist(PatchListCacheImpl.FILE_NAME, PatchListKey.class, PatchList.class).maximumWeight(0xA00000L).loader(PatchListLoader.class).weigher(PatchListWeigher.class);
                this.persist(PatchListCacheImpl.INTRA_NAME, IntraLineDiffKey.class, IntraLineDiff.class).maximumWeight(0xA00000L).loader(IntraLineLoader.class).weigher(IntraLineWeigher.class);
                this.bind(PatchListCacheImpl.class);
                this.bind(PatchListCache.class).to(PatchListCacheImpl.class);
            }
        };
    }

    @Inject
    PatchListCacheImpl(@Named(value="diff") LoadingCache<PatchListKey, PatchList> fileCache, @Named(value="diff_intraline") LoadingCache<IntraLineDiffKey, IntraLineDiff> intraCache, @GerritServerConfig Config cfg) {
        this.fileCache = fileCache;
        this.intraCache = intraCache;
        this.computeIntraline = cfg.getBoolean("cache", INTRA_NAME, "enabled", cfg.getBoolean("cache", FILE_NAME, "intraline", true));
    }

    @Override
    public PatchList get(PatchListKey key) throws PatchListNotAvailableException {
        try {
            return this.fileCache.get(key);
        }
        catch (ExecutionException e) {
            PatchListLoader.log.warn("Error computing " + key, e);
            throw new PatchListNotAvailableException(e.getCause());
        }
    }

    @Override
    public PatchList get(Change change, PatchSet patchSet) throws PatchListNotAvailableException {
        Project.NameKey projectKey = change.getProject();
        AnyObjectId a = null;
        if (patchSet.getRevision() == null) {
            throw new PatchListNotAvailableException("revision is null for " + patchSet.getId());
        }
        ObjectId b = ObjectId.fromString(patchSet.getRevision().get());
        AccountDiffPreference.Whitespace ws = AccountDiffPreference.Whitespace.IGNORE_NONE;
        return this.get(new PatchListKey(projectKey, a, b, ws));
    }

    @Override
    public IntraLineDiff getIntraLineDiff(IntraLineDiffKey key) {
        if (this.computeIntraline) {
            try {
                return this.intraCache.get(key);
            }
            catch (ExecutionException e) {
                IntraLineLoader.log.warn("Error computing " + key, e);
                return new IntraLineDiff(IntraLineDiff.Status.ERROR);
            }
        }
        return new IntraLineDiff(IntraLineDiff.Status.DISABLED);
    }
}

