/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.account.CapabilityControl;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.TrackingFooters;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.strategy.SubmitStrategyFactory;
import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.ChangeIndex;
import com.google.gerrit.server.index.IndexCollection;
import com.google.gerrit.server.index.Schema;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ListChildProjects;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.query.IntPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryBuilder;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.AddedPredicate;
import com.google.gerrit.server.query.change.AfterPredicate;
import com.google.gerrit.server.query.change.AgePredicate;
import com.google.gerrit.server.query.change.BeforePredicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIdPredicate;
import com.google.gerrit.server.query.change.ChangeQueryRewriter;
import com.google.gerrit.server.query.change.ChangeStatusPredicate;
import com.google.gerrit.server.query.change.CommentPredicate;
import com.google.gerrit.server.query.change.CommitPredicate;
import com.google.gerrit.server.query.change.ConflictsCache;
import com.google.gerrit.server.query.change.ConflictsPredicate;
import com.google.gerrit.server.query.change.DeletedPredicate;
import com.google.gerrit.server.query.change.DeltaPredicate;
import com.google.gerrit.server.query.change.EqualsFilePredicate;
import com.google.gerrit.server.query.change.EqualsPathPredicate;
import com.google.gerrit.server.query.change.HasDraftByPredicate;
import com.google.gerrit.server.query.change.IsMergeablePredicate;
import com.google.gerrit.server.query.change.IsReviewedPredicate;
import com.google.gerrit.server.query.change.IsStarredByPredicate;
import com.google.gerrit.server.query.change.IsVisibleToPredicate;
import com.google.gerrit.server.query.change.IsWatchedByPredicate;
import com.google.gerrit.server.query.change.LabelPredicate;
import com.google.gerrit.server.query.change.LegacyChangeIdPredicate;
import com.google.gerrit.server.query.change.MessagePredicate;
import com.google.gerrit.server.query.change.OwnerPredicate;
import com.google.gerrit.server.query.change.OwnerinPredicate;
import com.google.gerrit.server.query.change.ParentProjectPredicate;
import com.google.gerrit.server.query.change.PredicateArgs;
import com.google.gerrit.server.query.change.ProjectPredicate;
import com.google.gerrit.server.query.change.ProjectPrefixPredicate;
import com.google.gerrit.server.query.change.RefPredicate;
import com.google.gerrit.server.query.change.RegexPathPredicate;
import com.google.gerrit.server.query.change.RegexProjectPredicate;
import com.google.gerrit.server.query.change.RegexRefPredicate;
import com.google.gerrit.server.query.change.RegexTopicPredicate;
import com.google.gerrit.server.query.change.ReviewerPredicate;
import com.google.gerrit.server.query.change.ReviewerinPredicate;
import com.google.gerrit.server.query.change.SingleGroupUser;
import com.google.gerrit.server.query.change.SortKeyPredicate;
import com.google.gerrit.server.query.change.TopicPredicate;
import com.google.gerrit.server.query.change.TrackingIdPredicate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.Config;

public class ChangeQueryBuilder
extends QueryBuilder<ChangeData> {
    private static final Pattern PAT_LEGACY_ID = Pattern.compile("^[1-9][0-9]*$");
    private static final Pattern PAT_CHANGE_ID = Pattern.compile("^[iI][0-9a-f]{4,}.*$");
    private static final Pattern DEF_CHANGE = Pattern.compile("^([1-9][0-9]*|[iI][0-9a-f]{4,}.*)$");
    public static final String FIELD_ADDED = "added";
    public static final String FIELD_AFTER = "after";
    public static final String FIELD_AGE = "age";
    public static final String FIELD_BEFORE = "before";
    public static final String FIELD_BRANCH = "branch";
    public static final String FIELD_CHANGE = "change";
    public static final String FIELD_COMMENT = "comment";
    public static final String FIELD_COMMIT = "commit";
    public static final String FIELD_CONFLICTS = "conflicts";
    public static final String FIELD_DELETED = "deleted";
    public static final String FIELD_DELTA = "delta";
    public static final String FIELD_DRAFTBY = "draftby";
    public static final String FIELD_FILE = "file";
    public static final String FIELD_IS = "is";
    public static final String FIELD_HAS = "has";
    public static final String FIELD_LABEL = "label";
    public static final String FIELD_LIMIT = "limit";
    public static final String FIELD_MERGEABLE = "mergeable";
    public static final String FIELD_MESSAGE = "message";
    public static final String FIELD_OWNER = "owner";
    public static final String FIELD_OWNERIN = "ownerin";
    public static final String FIELD_PARENTPROJECT = "parentproject";
    public static final String FIELD_PATH = "path";
    public static final String FIELD_PROJECT = "project";
    public static final String FIELD_PROJECTS = "projects";
    public static final String FIELD_REF = "ref";
    public static final String FIELD_REVIEWER = "reviewer";
    public static final String FIELD_REVIEWERIN = "reviewerin";
    public static final String FIELD_STARREDBY = "starredby";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_TOPIC = "topic";
    public static final String FIELD_TR = "tr";
    public static final String FIELD_VISIBLETO = "visibleto";
    public static final String FIELD_WATCHEDBY = "watchedby";
    public static final String ARG_ID_USER = "user";
    public static final String ARG_ID_GROUP = "group";
    private static final QueryBuilder.Definition<ChangeData, ChangeQueryBuilder> mydef = new QueryBuilder.Definition(ChangeQueryBuilder.class);
    private final Arguments args;
    private final CurrentUser currentUser;

    public static Integer getLimit(Predicate<ChangeData> p) {
        IntPredicate ip = ChangeQueryBuilder.find(p, IntPredicate.class, FIELD_LIMIT);
        return ip != null ? Integer.valueOf(ip.intValue()) : null;
    }

    public static boolean hasNonTrivialSortKeyAfter(Schema<ChangeData> schema, Predicate<ChangeData> p) {
        SortKeyPredicate after = ChangeQueryBuilder.find(p, SortKeyPredicate.class, "sortkey_after");
        return after != null && after.getMaxValue(schema) > 0L;
    }

    public static boolean hasSortKey(Predicate<ChangeData> p) {
        return ChangeQueryBuilder.find(p, SortKeyPredicate.class, "sortkey_after") != null || ChangeQueryBuilder.find(p, SortKeyPredicate.class, "sortkey_before") != null;
    }

    @Inject
    public ChangeQueryBuilder(Arguments args, @Assisted CurrentUser currentUser) {
        super(mydef);
        this.args = args;
        this.currentUser = currentUser;
    }

    @VisibleForTesting
    protected ChangeQueryBuilder(QueryBuilder.Definition<ChangeData, ? extends ChangeQueryBuilder> def, Arguments args, CurrentUser currentUser) {
        super(def);
        this.args = args;
        this.currentUser = currentUser;
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> age(String value) {
        return new AgePredicate(ChangeQueryBuilder.schema(this.args.indexes), value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> before(String value) throws QueryParseException {
        return new BeforePredicate(ChangeQueryBuilder.schema(this.args.indexes), value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> until(String value) throws QueryParseException {
        return this.before(value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> after(String value) throws QueryParseException {
        return new AfterPredicate(ChangeQueryBuilder.schema(this.args.indexes), value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> since(String value) throws QueryParseException {
        return this.after(value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> change(String query) {
        if (PAT_LEGACY_ID.matcher(query).matches()) {
            return new LegacyChangeIdPredicate(this.args, Change.Id.parse(query));
        }
        if (PAT_CHANGE_ID.matcher(query).matches()) {
            return new ChangeIdPredicate(this.args, ChangeQueryBuilder.parseChangeId(query));
        }
        throw new IllegalArgumentException();
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> comment(String value) throws QueryParseException {
        ChangeIndex index = this.args.indexes.getSearchIndex();
        return new CommentPredicate(this.args, index, value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> status(String statusName) {
        if ("open".equals(statusName) || "pending".equals(statusName)) {
            return this.status_open();
        }
        if ("closed".equals(statusName)) {
            return ChangeStatusPredicate.closed(this.args.db);
        }
        if ("reviewed".equalsIgnoreCase(statusName)) {
            return new IsReviewedPredicate();
        }
        return new ChangeStatusPredicate(statusName);
    }

    public Predicate<ChangeData> status_open() {
        return ChangeStatusPredicate.open(this.args.db);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> has(String value) {
        if ("star".equalsIgnoreCase(value)) {
            return new IsStarredByPredicate(this.args, this.currentUser);
        }
        if ("draft".equalsIgnoreCase(value)) {
            return new HasDraftByPredicate(this.args, this.self());
        }
        throw new IllegalArgumentException();
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> is(String value) throws QueryParseException {
        if ("starred".equalsIgnoreCase(value)) {
            return new IsStarredByPredicate(this.args, this.currentUser);
        }
        if ("watched".equalsIgnoreCase(value)) {
            return new IsWatchedByPredicate(this.args, this.currentUser, false);
        }
        if ("visible".equalsIgnoreCase(value)) {
            return this.is_visible();
        }
        if ("reviewed".equalsIgnoreCase(value)) {
            return new IsReviewedPredicate();
        }
        if (FIELD_OWNER.equalsIgnoreCase(value)) {
            return new OwnerPredicate(this.self());
        }
        if (FIELD_REVIEWER.equalsIgnoreCase(value)) {
            return new ReviewerPredicate(this.self(), this.args.allowsDrafts);
        }
        if (FIELD_MERGEABLE.equalsIgnoreCase(value)) {
            return new IsMergeablePredicate();
        }
        try {
            return this.status(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException();
        }
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> commit(String id) {
        return new CommitPredicate(this.args, AbbreviatedObjectId.fromString(id));
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> conflicts(String value) throws OrmException, QueryParseException {
        return new ConflictsPredicate(this.args, value, this.parseChange(value));
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> p(String name) {
        return this.project(name);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> project(String name) {
        if (name.startsWith("^")) {
            return new RegexProjectPredicate(name);
        }
        return new ProjectPredicate(name);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> projects(String name) throws QueryParseException {
        if (!ChangeQueryBuilder.schema(this.args.indexes).hasField(ChangeField.PROJECTS)) {
            throw new QueryParseException("Unsupported operator: projects");
        }
        return new ProjectPrefixPredicate(name);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> parentproject(String name) {
        return new ParentProjectPredicate(this.args.db, this.args.projectCache, this.args.listChildProjects, this.args.self, name);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> branch(String name) {
        if (name.startsWith("^")) {
            return this.ref("^" + ChangeQueryBuilder.branchToRef(name.substring(1)));
        }
        return this.ref(ChangeQueryBuilder.branchToRef(name));
    }

    private static String branchToRef(String name) {
        if (!name.startsWith("refs/heads/")) {
            return "refs/heads/" + name;
        }
        return name;
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> topic(String name) {
        if (name.startsWith("^")) {
            return new RegexTopicPredicate(ChangeQueryBuilder.schema(this.args.indexes), name);
        }
        return new TopicPredicate(ChangeQueryBuilder.schema(this.args.indexes), name);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> ref(String ref) {
        if (ref.startsWith("^")) {
            return new RegexRefPredicate(ref);
        }
        return new RefPredicate(ref);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> f(String file) throws QueryParseException {
        return this.file(file);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> file(String file) throws QueryParseException {
        if (file.startsWith("^")) {
            return new RegexPathPredicate(FIELD_FILE, file);
        }
        return EqualsFilePredicate.create(this.args, file);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> path(String path) throws QueryParseException {
        if (path.startsWith("^")) {
            return new RegexPathPredicate(FIELD_PATH, path);
        }
        return new EqualsPathPredicate(FIELD_PATH, path);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> label(String name) throws QueryParseException, OrmException {
        Set<Account.Id> accounts = null;
        AccountGroup.UUID group = null;
        String[] splitReviewer = name.split(",", 2);
        name = splitReviewer[0];
        if (splitReviewer.length == 2) {
            PredicateArgs lblArgs = new PredicateArgs(splitReviewer[1]);
            for (Map.Entry<String, String> pair : lblArgs.keyValue.entrySet()) {
                if (pair.getKey().equalsIgnoreCase(ARG_ID_USER)) {
                    accounts = this.parseAccount(pair.getValue());
                    continue;
                }
                if (pair.getKey().equalsIgnoreCase(ARG_ID_GROUP)) {
                    group = this.parseGroup(pair.getValue()).getUUID();
                    continue;
                }
                throw new QueryParseException("Invalid argument identifier '" + pair.getKey() + "'");
            }
            for (String value : lblArgs.positional) {
                if (accounts != null || group != null) {
                    throw new QueryParseException("more than one user/group specified (" + value + ")");
                }
                try {
                    accounts = this.parseAccount(value);
                }
                catch (QueryParseException qpex) {
                    try {
                        group = this.parseGroup(value).getUUID();
                    }
                    catch (QueryParseException e) {
                        throw ChangeQueryBuilder.error("Neither user nor group " + value + " found");
                    }
                }
            }
        }
        return new LabelPredicate(this.args.projectCache, this.args.changeControlGenericFactory, this.args.userFactory, this.args.db, name, accounts, group);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> message(String text) throws QueryParseException {
        ChangeIndex index = this.args.indexes.getSearchIndex();
        return new MessagePredicate(this.args, index, text);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> starredby(String who) throws QueryParseException, OrmException {
        if ("self".equals(who)) {
            return new IsStarredByPredicate(this.args, this.currentUser);
        }
        Set<Account.Id> m = this.parseAccount(who);
        ArrayList<IsStarredByPredicate> p = Lists.newArrayListWithCapacity(m.size());
        for (Account.Id id : m) {
            p.add(new IsStarredByPredicate(this.args, this.args.userFactory.create(this.args.db, id)));
        }
        return Predicate.or(p);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> watchedby(String who) throws QueryParseException, OrmException {
        Set<Account.Id> m = this.parseAccount(who);
        ArrayList<IsWatchedByPredicate> p = Lists.newArrayListWithCapacity(m.size());
        for (Account.Id id : m) {
            if (this.currentUser.isIdentifiedUser() && id.equals(((IdentifiedUser)this.currentUser).getAccountId())) {
                p.add(new IsWatchedByPredicate(this.args, this.currentUser, false));
                continue;
            }
            p.add(new IsWatchedByPredicate(this.args, this.args.userFactory.create(this.args.db, id), true));
        }
        return Predicate.or(p);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> draftby(String who) throws QueryParseException, OrmException {
        Set<Account.Id> m = this.parseAccount(who);
        ArrayList<HasDraftByPredicate> p = Lists.newArrayListWithCapacity(m.size());
        for (Account.Id id : m) {
            p.add(new HasDraftByPredicate(this.args, id));
        }
        return Predicate.or(p);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> visibleto(String who) throws QueryParseException, OrmException {
        if ("self".equals(who)) {
            return this.is_visible();
        }
        Set<Account.Id> m = this.args.accountResolver.findAll(who);
        if (!m.isEmpty()) {
            ArrayList p = Lists.newArrayListWithCapacity(m.size());
            Iterator<Account.Id> i$ = m.iterator();
            if (i$.hasNext()) {
                Account.Id id = i$.next();
                return this.visibleto(this.args.userFactory.create(this.args.db, id));
            }
            return Predicate.or(p);
        }
        Collection<GroupReference> suggestions = this.args.groupBackend.suggest(who, null);
        if (!suggestions.isEmpty()) {
            HashSet<AccountGroup.UUID> ids = new HashSet<AccountGroup.UUID>();
            for (GroupReference ref : suggestions) {
                ids.add(ref.getUUID());
            }
            return this.visibleto(new SingleGroupUser(this.args.capabilityControlFactory, ids));
        }
        throw ChangeQueryBuilder.error("No user or group matches \"" + who + "\".");
    }

    public Predicate<ChangeData> visibleto(CurrentUser user) {
        return new IsVisibleToPredicate(this.args.db, this.args.changeControlGenericFactory, user);
    }

    public Predicate<ChangeData> is_visible() {
        return this.visibleto(this.currentUser);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> o(String who) throws QueryParseException, OrmException {
        return this.owner(who);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> owner(String who) throws QueryParseException, OrmException {
        Set<Account.Id> m = this.parseAccount(who);
        ArrayList<OwnerPredicate> p = Lists.newArrayListWithCapacity(m.size());
        for (Account.Id id : m) {
            p.add(new OwnerPredicate(id));
        }
        return Predicate.or(p);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> ownerin(String group) throws QueryParseException {
        GroupReference g = GroupBackends.findBestSuggestion(this.args.groupBackend, group);
        if (g == null) {
            throw ChangeQueryBuilder.error("Group " + group + " not found");
        }
        return new OwnerinPredicate(this.args.db, this.args.userFactory, g.getUUID());
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> r(String who) throws QueryParseException, OrmException {
        return this.reviewer(who);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> reviewer(String who) throws QueryParseException, OrmException {
        Set<Account.Id> m = this.parseAccount(who);
        ArrayList<ReviewerPredicate> p = Lists.newArrayListWithCapacity(m.size());
        for (Account.Id id : m) {
            p.add(new ReviewerPredicate(id, this.args.allowsDrafts));
        }
        return Predicate.or(p);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> reviewerin(String group) throws QueryParseException {
        GroupReference g = GroupBackends.findBestSuggestion(this.args.groupBackend, group);
        if (g == null) {
            throw ChangeQueryBuilder.error("Group " + group + " not found");
        }
        return new ReviewerinPredicate(this.args.db, this.args.userFactory, g.getUUID());
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> tr(String trackingId) {
        return new TrackingIdPredicate(this.args.trackingFooters, trackingId);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> bug(String trackingId) {
        return this.tr(trackingId);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> limit(String limit) {
        return this.limit(Integer.parseInt(limit));
    }

    public Predicate<ChangeData> limit(int limit) {
        return new LimitPredicate(limit);
    }

    boolean supportsSortKey() {
        return SortKeyPredicate.hasSortKeyField(ChangeQueryBuilder.schema(this.args.indexes));
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> sortkey_after(String sortKey) {
        return new SortKeyPredicate.After(ChangeQueryBuilder.schema(this.args.indexes), this.args.db, sortKey);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> sortkey_before(String sortKey) {
        return new SortKeyPredicate.Before(ChangeQueryBuilder.schema(this.args.indexes), this.args.db, sortKey);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> resume_sortkey(String sortKey) {
        return this.sortkey_before(sortKey);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> added(String value) throws QueryParseException {
        return new AddedPredicate(value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> deleted(String value) throws QueryParseException {
        return new DeletedPredicate(value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> size(String value) throws QueryParseException {
        return this.delta(value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> delta(String value) throws QueryParseException {
        return new DeltaPredicate(value);
    }

    @Override
    protected Predicate<ChangeData> defaultField(String query) {
        if (query.startsWith("refs/")) {
            return this.ref(query);
        }
        if (DEF_CHANGE.matcher(query).matches()) {
            return this.change(query);
        }
        ArrayList<Predicate<ChangeData>> predicates = Lists.newArrayListWithCapacity(9);
        try {
            predicates.add(this.commit(query));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            predicates.add(this.owner(query));
        }
        catch (QueryParseException | OrmException e) {
            // empty catch block
        }
        try {
            predicates.add(this.reviewer(query));
        }
        catch (QueryParseException | OrmException e) {
            // empty catch block
        }
        try {
            predicates.add(this.file(query));
        }
        catch (QueryParseException e) {
            // empty catch block
        }
        try {
            predicates.add(this.label(query));
        }
        catch (QueryParseException | OrmException e) {
            // empty catch block
        }
        try {
            predicates.add(this.message(query));
        }
        catch (QueryParseException e) {
            // empty catch block
        }
        try {
            predicates.add(this.comment(query));
        }
        catch (QueryParseException e) {
            // empty catch block
        }
        try {
            predicates.add(this.projects(query));
        }
        catch (QueryParseException queryParseException) {
            // empty catch block
        }
        predicates.add(this.ref(query));
        predicates.add(this.branch(query));
        predicates.add(this.topic(query));
        return Predicate.or(predicates);
    }

    private Set<Account.Id> parseAccount(String who) throws QueryParseException, OrmException {
        if ("self".equals(who)) {
            return Collections.singleton(this.self());
        }
        Set<Account.Id> matches = this.args.accountResolver.findAll(who);
        if (matches.isEmpty()) {
            throw ChangeQueryBuilder.error("User " + who + " not found");
        }
        return matches;
    }

    private GroupReference parseGroup(String group) throws QueryParseException {
        GroupReference g = GroupBackends.findBestSuggestion(this.args.groupBackend, group);
        if (g == null) {
            throw ChangeQueryBuilder.error("Group " + group + " not found");
        }
        return g;
    }

    private List<Change> parseChange(String value) throws OrmException, QueryParseException {
        if (PAT_LEGACY_ID.matcher(value).matches()) {
            return Collections.singletonList(this.args.db.get().changes().get(Change.Id.parse(value)));
        }
        if (PAT_CHANGE_ID.matcher(value).matches()) {
            Change.Key a = new Change.Key(ChangeQueryBuilder.parseChangeId(value));
            List<Change> changes = this.args.db.get().changes().byKeyRange(a, a.max()).toList();
            if (changes.isEmpty()) {
                throw ChangeQueryBuilder.error("Change " + value + " not found");
            }
            return changes;
        }
        throw ChangeQueryBuilder.error("Change " + value + " not found");
    }

    private static String parseChangeId(String value) {
        if (value.charAt(0) == 'i') {
            value = "I" + value.substring(1);
        }
        return value;
    }

    private Account.Id self() {
        if (this.currentUser.isIdentifiedUser()) {
            return ((IdentifiedUser)this.currentUser).getAccountId();
        }
        throw new IllegalArgumentException();
    }

    private static Schema<ChangeData> schema(@Nullable IndexCollection indexes) {
        ChangeIndex index = indexes != null ? indexes.getSearchIndex() : null;
        return index != null ? index.getSchema() : null;
    }

    static class LimitPredicate
    extends IntPredicate<ChangeData> {
        LimitPredicate(int limit) {
            super(ChangeQueryBuilder.FIELD_LIMIT, limit);
        }

        @Override
        public boolean match(ChangeData object) {
            return true;
        }

        @Override
        public int getCost() {
            return 0;
        }
    }

    public static interface Factory {
        public ChangeQueryBuilder create(CurrentUser var1);
    }

    @VisibleForTesting
    public static class Arguments {
        final Provider<ReviewDb> db;
        final Provider<ChangeQueryRewriter> rewriter;
        final IdentifiedUser.GenericFactory userFactory;
        final Provider<CurrentUser> self;
        final CapabilityControl.Factory capabilityControlFactory;
        final ChangeControl.GenericFactory changeControlGenericFactory;
        final ChangeData.Factory changeDataFactory;
        final AccountResolver accountResolver;
        final GroupBackend groupBackend;
        final AllProjectsName allProjectsName;
        final PatchListCache patchListCache;
        final GitRepositoryManager repoManager;
        final ProjectCache projectCache;
        final Provider<ListChildProjects> listChildProjects;
        final IndexCollection indexes;
        final SubmitStrategyFactory submitStrategyFactory;
        final ConflictsCache conflictsCache;
        final TrackingFooters trackingFooters;
        final boolean allowsDrafts;

        @Inject
        @VisibleForTesting
        public Arguments(Provider<ReviewDb> dbProvider, Provider<ChangeQueryRewriter> rewriter, IdentifiedUser.GenericFactory userFactory, Provider<CurrentUser> self, CapabilityControl.Factory capabilityControlFactory, ChangeControl.GenericFactory changeControlGenericFactory, ChangeData.Factory changeDataFactory, AccountResolver accountResolver, GroupBackend groupBackend, AllProjectsName allProjectsName, PatchListCache patchListCache, GitRepositoryManager repoManager, ProjectCache projectCache, Provider<ListChildProjects> listChildProjects, IndexCollection indexes, SubmitStrategyFactory submitStrategyFactory, ConflictsCache conflictsCache, TrackingFooters trackingFooters, @GerritServerConfig Config cfg) {
            this.db = dbProvider;
            this.rewriter = rewriter;
            this.userFactory = userFactory;
            this.self = self;
            this.capabilityControlFactory = capabilityControlFactory;
            this.changeControlGenericFactory = changeControlGenericFactory;
            this.changeDataFactory = changeDataFactory;
            this.accountResolver = accountResolver;
            this.groupBackend = groupBackend;
            this.allProjectsName = allProjectsName;
            this.patchListCache = patchListCache;
            this.repoManager = repoManager;
            this.projectCache = projectCache;
            this.listChildProjects = listChildProjects;
            this.indexes = indexes;
            this.submitStrategyFactory = submitStrategyFactory;
            this.conflictsCache = conflictsCache;
            this.trackingFooters = trackingFooters;
            this.allowsDrafts = cfg == null ? true : cfg.getBoolean(ChangeQueryBuilder.FIELD_CHANGE, "allowDrafts", true);
        }
    }
}

